/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExclusiveReadNoneStrategyTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FileExclusiveReadNoneStrategyTest.class);
    private String fileUrl = "file://target/exclusiveread/slowfile?noop=true&consumer.delay=500&readLock=none";

    @Override
    protected void setUp() throws Exception {
        FileExclusiveReadNoneStrategyTest.deleteDirectory("target/exclusiveread");
        FileExclusiveReadNoneStrategyTest.createDirectory("target/exclusiveread/slowfile");
        super.setUp();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:start").process((Processor)new MySlowFileProcessor());
                this.from(FileExclusiveReadNoneStrategyTest.this.fileUrl + "&readLockTimeout=1000").to("mock:result");
            }
        };
    }

    public void testPollFileWhileSlowFileIsBeingWritten() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Create the slow file");
        mock.assertIsSatisfied();
        String body = (String)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(String.class);
        LOG.debug("Body is: " + body);
        FileExclusiveReadNoneStrategyTest.assertFalse((String)"Should not wait and read the entire file", (boolean)body.endsWith("Bye World"));
    }

    private static class MySlowFileProcessor
    implements Processor {
        private MySlowFileProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            LOG.info("Creating a slow file with no locks...");
            File file = new File("target/exclusiveread/slowfile/hello.txt");
            FileOutputStream fos = new FileOutputStream(file);
            fos.write("Hello World".getBytes());
            for (int i = 0; i < 3; ++i) {
                Thread.sleep(1000L);
                fos.write(("Line #" + i).getBytes());
                LOG.info("Appending to slowfile");
            }
            fos.write("Bye World".getBytes());
            fos.close();
            LOG.info("... done creating slowfile");
        }
    }
}

