/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;

public class FileMoveErrorOnExceptionNotHandledTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileMoveErrorOnExceptionNotHandledTest.deleteDirectory("target/move");
        super.setUp();
    }

    public void testMoveError() throws Exception {
        this.getMockEndpoint("mock:before").expectedMessageCount(1);
        this.getMockEndpoint("mock:after").expectedMessageCount(0);
        this.getMockEndpoint("mock:damn").expectedMessageCount(1);
        this.getMockEndpoint("mock:damn").expectedFileExists("target/move/error/hello.txt");
        this.template.sendBodyAndHeader("file:target/move", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("file:target/move?moveFailed=error").onException(IllegalArgumentException.class).to("mock:damn")).end().to("mock:before").throwException((Exception)new IllegalArgumentException("Damn")).to("mock:after");
            }
        };
    }
}

