/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FileProduceOverruleExpressionTest
extends ContextTestSupport {
    public void testNoOverrule() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelFileName", (Object)"hello.txt");
        mock.expectedFileExists("target/write/copy-of-hello.txt", "Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testOverrule() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelFileName", (Object)"hello.txt");
        ((ValueBuilder)mock.message(0).header("CamelOverruleFileName")).isNull();
        mock.expectedFileExists("target/write/copy-of-overruled.txt", "Hello World");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CamelFileName", "hello.txt");
        map.put("CamelOverruleFileName", "overruled.txt");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", map);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        FileProduceOverruleExpressionTest.deleteDirectory("target/write");
        super.setUp();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to(new String[]{"file://target/write?fileName=copy-of-${file:name}", "mock:result"});
            }
        };
    }
}

