/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileProducerFileExistIgnoreTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerFileExistIgnoreTest.deleteDirectory("target/file");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/file", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
    }

    public void testIgnore() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists("target/file/hello.txt", "Hello World");
        this.template.sendBodyAndHeader("file://target/file?fileExist=Ignore", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/file?noop=true&delay=1000").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

