/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.component.file.GenericFileOperationFailedException;

public class FileProducerTempFileExistsIssueTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerTempFileExistsIssueTest.deleteDirectory("target/tempprefix");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testIllegalConfiguration() throws Exception {
        try {
            this.context.getEndpoint("file://target/tempprefix?fileExist=Append&tempPrefix=foo").createProducer();
            FileProducerTempFileExistsIssueTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            FileProducerTempFileExistsIssueTest.assertEquals((String)"You cannot set both fileExist=Append and tempPrefix/tempFileName options", (String)e.getMessage());
        }
        try {
            this.context.getEndpoint("file://target/tempprefix?fileExist=Append&tempFileName=foo").createProducer();
            FileProducerTempFileExistsIssueTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            FileProducerTempFileExistsIssueTest.assertEquals((String)"You cannot set both fileExist=Append and tempPrefix/tempFileName options", (String)e.getMessage());
        }
    }

    public void testWriteUsingTempPrefixButFileExist() throws Exception {
        this.template.sendBodyAndHeader("file://target/tempprefix", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/tempprefix?tempPrefix=foo", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/tempprefix/hello.txt");
        FileProducerTempFileExistsIssueTest.assertEquals((boolean)true, (boolean)file.exists());
        FileProducerTempFileExistsIssueTest.assertEquals((String)"Bye World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)file)));
    }

    public void testWriteUsingTempPrefixButBothFileExist() throws Exception {
        this.template.sendBodyAndHeader("file://target/tempprefix", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/tempprefix", (Object)"Hello World", "CamelFileName", (Object)"foohello.txt");
        this.template.sendBodyAndHeader("file://target/tempprefix?tempPrefix=foo", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/tempprefix/hello.txt");
        FileProducerTempFileExistsIssueTest.assertEquals((boolean)true, (boolean)file.exists());
        FileProducerTempFileExistsIssueTest.assertEquals((String)"Bye World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)file)));
    }

    public void testWriteUsingTempPrefixButFileExistOverride() throws Exception {
        this.template.sendBodyAndHeader("file://target/tempprefix", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/tempprefix?tempPrefix=foo&fileExist=Override", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/tempprefix/hello.txt");
        FileProducerTempFileExistsIssueTest.assertEquals((boolean)true, (boolean)file.exists());
        FileProducerTempFileExistsIssueTest.assertEquals((String)"Bye World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)file)));
    }

    public void testWriteUsingTempPrefixButFileExistIgnore() throws Exception {
        this.template.sendBodyAndHeader("file://target/tempprefix", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file://target/tempprefix?tempPrefix=foo&fileExist=Ignore", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/tempprefix/hello.txt");
        FileProducerTempFileExistsIssueTest.assertEquals((boolean)true, (boolean)file.exists());
        FileProducerTempFileExistsIssueTest.assertEquals((String)"Hello World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)file)));
    }

    public void testWriteUsingTempPrefixButFileExistFail() throws Exception {
        this.template.sendBodyAndHeader("file://target/tempprefix", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        try {
            this.template.sendBodyAndHeader("file://target/tempprefix?tempPrefix=foo&fileExist=Fail", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
            FileProducerTempFileExistsIssueTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            GenericFileOperationFailedException cause = FileProducerTempFileExistsIssueTest.assertIsInstanceOf(GenericFileOperationFailedException.class, e.getCause());
            FileProducerTempFileExistsIssueTest.assertTrue((boolean)cause.getMessage().startsWith("File already exist"));
        }
        File file = new File("target/tempprefix/hello.txt");
        FileProducerTempFileExistsIssueTest.assertEquals((boolean)true, (boolean)file.exists());
        FileProducerTempFileExistsIssueTest.assertEquals((String)"Hello World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)file)));
    }
}

