/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileSortByExpressionTest
extends ContextTestSupport {
    private String fileUrl = "file://target/filesorter/";

    @Override
    protected void setUp() throws Exception {
        FileSortByExpressionTest.deleteDirectory("target/filesorter");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private void prepareFolder(String folder) {
        this.template.sendBodyAndHeader("file:target/filesorter/" + folder, (Object)"Hello Paris", "CamelFileName", (Object)"paris.dat");
        this.template.sendBodyAndHeader("file:target/filesorter/" + folder, (Object)"Hello London", "CamelFileName", (Object)"london.txt");
        this.template.sendBodyAndHeader("file:target/filesorter/" + folder, (Object)"Hello Copenhagen", "CamelFileName", (Object)"copenhagen.xml");
    }

    public void testSortFiles() throws Exception {
        this.prepareFolder("a");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from(FileSortByExpressionTest.this.fileUrl + "a/?sortBy=file:ext").to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris", "Hello London", "Hello Copenhagen"});
        this.assertMockEndpointsSatisfied();
    }

    public void testSortFilesReverse() throws Exception {
        this.prepareFolder("b");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileSortByExpressionTest.this.fileUrl + "b/?sortBy=reverse:file:ext").convertBodyTo(String.class)).to("mock:reverse");
            }
        });
        this.context.start();
        MockEndpoint reverse = this.getMockEndpoint("mock:reverse");
        reverse.expectedBodiesReceived(new Object[]{"Hello Copenhagen", "Hello London", "Hello Paris"});
        this.assertMockEndpointsSatisfied();
    }
}

