/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileSortByIgnoreCaseExpressionTest
extends ContextTestSupport {
    private String fileUrl = "file://target/filesorter/";

    @Override
    protected void setUp() throws Exception {
        FileSortByIgnoreCaseExpressionTest.deleteDirectory("target/filesorter");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private void prepareFolder(String folder) {
        this.template.sendBodyAndHeader("file:target/filesorter/" + folder, (Object)"Hello Paris", "CamelFileName", (Object)"report-3.dat");
        this.template.sendBodyAndHeader("file:target/filesorter/" + folder, (Object)"Hello London", "CamelFileName", (Object)"REPORT-2.txt");
        this.template.sendBodyAndHeader("file:target/filesorter/" + folder, (Object)"Hello Copenhagen", "CamelFileName", (Object)"Report-1.xml");
    }

    public void testSortFilesByNameWithCase() throws Exception {
        this.prepareFolder("a");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileSortByIgnoreCaseExpressionTest.this.fileUrl + "a/?sortBy=file:name&initialDelay=250&delay=1000").convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello London", "Hello Copenhagen", "Hello Paris"});
        this.assertMockEndpointsSatisfied();
    }

    public void testSortFilesByNameNoCase() throws Exception {
        this.prepareFolder("b");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileSortByIgnoreCaseExpressionTest.this.fileUrl + "b/?sortBy=ignoreCase:file:name&initialDelay=500&delay=1000").convertBodyTo(String.class)).to("mock:nocase");
            }
        });
        this.context.start();
        MockEndpoint nocase = this.getMockEndpoint("mock:nocase");
        nocase.expectedBodiesReceived(new Object[]{"Hello Copenhagen", "Hello London", "Hello Paris"});
        this.assertMockEndpointsSatisfied();
    }

    public void testSortFilesByNameNoCaseReverse() throws Exception {
        this.prepareFolder("c");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(FileSortByIgnoreCaseExpressionTest.this.fileUrl + "c/?sortBy=reverse:ignoreCase:file:name&initialDelay=750&delay=1000").convertBodyTo(String.class)).to("mock:nocasereverse");
            }
        });
        this.context.start();
        MockEndpoint nocasereverse = this.getMockEndpoint("mock:nocasereverse");
        nocasereverse.expectedBodiesReceived(new Object[]{"Hello Paris", "Hello London", "Hello Copenhagen"});
        this.assertMockEndpointsSatisfied();
    }
}

