/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FileToFileWithFlattenTest
extends ContextTestSupport {
    private String fileUrl = "file://target/flatten-in";

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected void setUp() throws Exception {
        FileToFileWithFlattenTest.deleteDirectory("target/flatten-in");
        FileToFileWithFlattenTest.deleteDirectory("target/flatten-out");
        super.setUp();
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Hello World", "CamelFileName", (Object)"sub/hello.txt");
        this.template.sendBodyAndHeader(this.fileUrl, (Object)"Goodday World", "CamelFileName", (Object)"sub/sub2/goodday.txt");
    }

    @Override
    protected void tearDown() throws Exception {
        this.context.stop();
        super.tearDown();
    }

    public void testFlatternConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://target/flatten-in?recursive=true&flatten=true").to(new String[]{"file://target/flatten-out", "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedFileExists("target/flatten-out/bye.txt");
        mock.expectedFileExists("target/flatten-out/hello.txt");
        mock.expectedFileExists("target/flatten-out/goodday.txt");
        mock.expectedFileExists("target/flatten-in/.camel/bye.txt");
        mock.expectedFileExists("target/flatten-in/sub/.camel/hello.txt");
        mock.expectedFileExists("target/flatten-in/sub/sub2/.camel/goodday.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testFlatternProducer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file://target/flatten-in?recursive=true").to(new String[]{"file://target/flatten-out?flatten=true", "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        mock.expectedFileExists("target/flatten-out/bye.txt");
        mock.expectedFileExists("target/flatten-out/hello.txt");
        mock.expectedFileExists("target/flatten-out/goodday.txt");
        mock.expectedFileExists("target/flatten-in/.camel/bye.txt");
        mock.expectedFileExists("target/flatten-in/sub/.camel/hello.txt");
        mock.expectedFileExists("target/flatten-in/sub/sub2/.camel/goodday.txt");
        this.assertMockEndpointsSatisfied();
    }
}

