/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class FilerConsumerRetryDoneFileNameTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilerConsumerRetryDoneFileNameTest.deleteDirectory("target/done");
        super.setUp();
    }

    public void testDoneFile() throws Exception {
        this.getMockEndpoint("mock:input").expectedMessageCount(2);
        this.getMockEndpoint("mock:input").expectedFileExists("target/done/.camel/hello.txt");
        this.template.sendBodyAndHeader("file:target/done", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader("file:target/done", (Object)"", "CamelFileName", (Object)"done");
        this.assertMockEndpointsSatisfied();
        File file = new File("target/done/done");
        FilerConsumerRetryDoneFileNameTest.assertFalse((String)("Done file should be deleted: " + file), (boolean)file.exists());
        file = new File("target/done/.camel/hello.txt");
        FilerConsumerRetryDoneFileNameTest.assertTrue((String)("Original file should be moved: " + file), (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/done?doneFileName=done&initialDelay=0&delay=10").to("mock:input")).process(new Processor(){
                    int index;

                    public void process(Exchange exchange) throws Exception {
                        if (this.index++ == 0) {
                            File file = new File("target/done/done");
                            TestCase.assertTrue((String)("Done file should exists: " + file), (boolean)file.exists());
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                });
            }
        };
    }
}

