/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class FilerProducerDoneFileNameRouteTest
extends ContextTestSupport {
    private Properties myProp = new Properties();

    @Override
    protected void setUp() throws Exception {
        FilerProducerDoneFileNameRouteTest.deleteDirectory("target/done");
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myProp", (Object)this.myProp);
        return jndi;
    }

    public void testProducerPlaceholderPrefixDoneFileName() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        FilerProducerDoneFileNameRouteTest.assertTrue((boolean)this.oneExchangeDone.matches(5L, TimeUnit.SECONDS));
        File file = new File("target/done/hello.txt");
        FilerProducerDoneFileNameRouteTest.assertEquals((String)"File should exists", (boolean)true, (boolean)file.exists());
        File done = new File("target/done/done-hello.txt");
        FilerProducerDoneFileNameRouteTest.assertEquals((String)"Done file should exists", (boolean)true, (boolean)done.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                FilerProducerDoneFileNameRouteTest.this.myProp.put("myDir", "target/done");
                PropertiesComponent pc = (PropertiesComponent)FilerProducerDoneFileNameRouteTest.this.context.getComponent("properties", PropertiesComponent.class);
                pc.setLocation("ref:myProp");
                ((RouteDefinition)this.from("direct:start").to("file:{{myDir}}?doneFileName=done-${file:name}")).to("mock:result");
            }
        };
    }
}

