/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.JndiRegistry;

public class FilerProducerDoneFileNameTest
extends ContextTestSupport {
    private Properties myProp = new Properties();

    @Override
    protected void setUp() throws Exception {
        FilerProducerDoneFileNameTest.deleteDirectory("target/done");
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myProp", (Object)this.myProp);
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = (PropertiesComponent)context.getComponent("properties", PropertiesComponent.class);
        pc.setLocation("ref:myProp");
        return context;
    }

    public void testProducerConstantDoneFileName() throws Exception {
        this.template.sendBodyAndHeader("file:target/done?doneFileName=done", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/done/hello.txt");
        FilerProducerDoneFileNameTest.assertEquals((String)"File should exists", (boolean)true, (boolean)file.exists());
        File done = new File("target/done/done");
        FilerProducerDoneFileNameTest.assertEquals((String)"Done file should exists", (boolean)true, (boolean)done.exists());
    }

    public void testProducerPrefixDoneFileName() throws Exception {
        this.template.sendBodyAndHeader("file:target/done?doneFileName=done-${file:name}", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/done/hello.txt");
        FilerProducerDoneFileNameTest.assertEquals((String)"File should exists", (boolean)true, (boolean)file.exists());
        File done = new File("target/done/done-hello.txt");
        FilerProducerDoneFileNameTest.assertEquals((String)"Done file should exists", (boolean)true, (boolean)done.exists());
    }

    public void testProducerExtDoneFileName() throws Exception {
        this.template.sendBodyAndHeader("file:target/done?doneFileName=${file:name}.done", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/done/hello.txt");
        FilerProducerDoneFileNameTest.assertEquals((String)"File should exists", (boolean)true, (boolean)file.exists());
        File done = new File("target/done/hello.txt.done");
        FilerProducerDoneFileNameTest.assertEquals((String)"Done file should exists", (boolean)true, (boolean)done.exists());
    }

    public void testProducerReplaceExtDoneFileName() throws Exception {
        this.template.sendBodyAndHeader("file:target/done?doneFileName=${file:name.noext}.done", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/done/hello.txt");
        FilerProducerDoneFileNameTest.assertEquals((String)"File should exists", (boolean)true, (boolean)file.exists());
        File done = new File("target/done/hello.done");
        FilerProducerDoneFileNameTest.assertEquals((String)"Done file should exists", (boolean)true, (boolean)done.exists());
    }

    public void testProducerInvalidDoneFileName() throws Exception {
        try {
            this.template.sendBodyAndHeader("file:target/done?doneFileName=${file:parent}/foo", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
            FilerProducerDoneFileNameTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            ExpressionIllegalSyntaxException cause = FilerProducerDoneFileNameTest.assertIsInstanceOf(ExpressionIllegalSyntaxException.class, e.getCause());
            FilerProducerDoneFileNameTest.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().endsWith("Cannot resolve reminder: ${file:parent}/foo"));
        }
    }

    public void testProducerEmptyDoneFileName() throws Exception {
        try {
            this.template.sendBodyAndHeader("file:target/done?doneFileName=", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
            FilerProducerDoneFileNameTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = FilerProducerDoneFileNameTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            FilerProducerDoneFileNameTest.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().startsWith("doneFileName must be specified and not empty"));
        }
    }

    public void testProducerPlaceholderPrefixDoneFileName() throws Exception {
        this.myProp.put("myDir", "target/done");
        this.template.sendBodyAndHeader("file:{{myDir}}?doneFileName=done-${file:name}", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/done/hello.txt");
        FilerProducerDoneFileNameTest.assertEquals((String)"File should exists", (boolean)true, (boolean)file.exists());
        File done = new File("target/done/done-hello.txt");
        FilerProducerDoneFileNameTest.assertEquals((String)"Done file should exists", (boolean)true, (boolean)done.exists());
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

