/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;

public class NewFileConsumerTest
extends ContextTestSupport {
    private MyFileEndpoint myFile;

    @Override
    protected void setUp() throws Exception {
        NewFileConsumerTest.deleteDirectory("target/myfile");
        super.setUp();
    }

    public void testNewFileConsumer() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/myfile", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        Thread.sleep(250L);
        NewFileConsumerTest.assertTrue((String)"Should have invoked postPollCheck", (boolean)this.myFile.isPost());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                NewFileConsumerTest.this.myFile = new MyFileEndpoint();
                NewFileConsumerTest.this.myFile.setCamelContext((CamelContext)NewFileConsumerTest.this.context);
                NewFileConsumerTest.this.myFile.setFile(new File("target/myfile"));
                this.from((Endpoint)NewFileConsumerTest.this.myFile).to("mock:result");
            }
        };
    }

    private class MyFileEndpoint
    extends FileEndpoint {
        private volatile boolean post;

        private MyFileEndpoint() {
        }

        protected FileConsumer newFileConsumer(Processor processor, GenericFileOperations<File> operations) {
            return new FileConsumer((GenericFileEndpoint)this, processor, operations){

                protected void postPollCheck() {
                    MyFileEndpoint.this.post = true;
                }
            };
        }

        public boolean isPost() {
            return this.post;
        }
    }
}

