/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.w3c.dom.Document;

public class XPathToFileTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        XPathToFileTest.deleteDirectory("target/xpath");
        super.setUp();
    }

    public void testXPathToFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        String xml = "<foo><person id=\"1\">Claus<country>SE</country></person><person id=\"2\">Jonathan<country>CA</country></person></foo>";
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)xml);
        this.template.sendBody("direct:start", (Object)doc);
        this.assertMockEndpointsSatisfied();
        File first = new File("target/xpath/xpath-0.xml");
        XPathToFileTest.assertTrue((String)"File xpath-0.xml should exists", (boolean)first.exists());
        XPathToFileTest.assertEquals((String)"<person id=\"1\">Claus<country>SE</country></person>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)first)));
        File second = new File("target/xpath/xpath-1.xml");
        XPathToFileTest.assertTrue((String)"File xpath-1.xml should exists", (boolean)second.exists());
        XPathToFileTest.assertEquals((String)"<person id=\"2\">Jonathan<country>CA</country></person>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)second)));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)this.from("direct:start").split((Expression)this.xpath("/foo/person")).log("${bodyAs(String)}")).to("file://target/xpath?fileName=xpath-${property.CamelSplitIndex}.xml")).to("mock:result");
            }
        };
    }
}

