/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.FileOutputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FileChangedZeroLengthReadLockTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileChangedZeroLengthReadLockTest.deleteDirectory("target/changed/");
        FileChangedZeroLengthReadLockTest.createDirectory("target/changed/in");
        super.setUp();
    }

    public void testChangedReadLock() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/changed/out/zerofile.dat");
        this.writeZeroLengthFile();
        this.assertMockEndpointsSatisfied();
    }

    private void writeZeroLengthFile() throws Exception {
        FileOutputStream fos = new FileOutputStream("target/changed/in/zerofile.dat");
        fos.flush();
        fos.close();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/changed/in?readLock=changed&readLockMinLength=0").to(new String[]{"file:target/changed/out", "mock:result"});
            }
        };
    }
}

