/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.stress;

import java.util.Random;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ThreadsDefinition;

public class FileAsyncStressManually
extends ContextTestSupport {
    public void testAsyncStress() throws Exception {
        if (FileAsyncStressManually.isPlatform("windows")) {
            return;
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(250);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("file:target/filestress?readLock=markerFile&maxMessagesPerPoll=25&move=backup").threads(10).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Random ran = new Random();
                        int delay = ran.nextInt(500) + 10;
                        Thread.sleep(delay);
                    }
                })).to("mock:result");
            }
        };
    }
}

