/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.stress;

import java.util.Random;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ThreadsDefinition;

public class FileAsyncStressTest
extends ContextTestSupport {
    private int files = 150;

    @Override
    protected void setUp() throws Exception {
        if (FileAsyncStressTest.isPlatform("windows")) {
            return;
        }
        super.setUp();
        FileAsyncStressTest.deleteDirectory("target/filestress");
        for (int i = 0; i < this.files; ++i) {
            this.template.sendBodyAndHeader("file:target/filestress", (Object)"Hello World", "CamelFileName", (Object)(i + ".txt"));
        }
    }

    public void testAsyncStress() throws Exception {
        if (FileAsyncStressTest.isPlatform("windows")) {
            return;
        }
        this.context.startRoute("foo");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(100);
        mock.setResultWaitTime(30000L);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("file:target/filestress?maxMessagesPerPoll=50").routeId("foo").noAutoStartup().threads(10).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Random ran = new Random();
                        int delay = ran.nextInt(50) + 10;
                        Thread.sleep(delay);
                    }
                })).to("mock:result");
            }
        };
    }
}

