/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.log.LogComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class LogComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        LogComponent comp = (LogComponent)this.context.getComponent("log", LogComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("log:foo?level=DEBUG");
        LogComponentConfigurationAndDocumentationTest.assertEquals((Object)"DEBUG", (Object)conf.getParameter("level"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        LogComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        LogComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"level\": { \"type\": \"java.lang.String\" }"));
        LogComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"groupInterval\": { \"type\": \"java.lang.Long\" }"));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        if (LogComponentConfigurationAndDocumentationTest.isJavaVersion("1.6")) {
            return;
        }
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("log");
        LogComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML if on Java 7", (Object)html);
    }
}

