/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class ThroughputLoggerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testSendMessageToLogUsingGroupSize() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:in").to("log:hello?groupSize=2")).delay(100L).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(4);
        this.template.sendBody("seda:in", (Object)"Hello World");
        this.template.sendBody("seda:in", (Object)"Hello World");
        this.template.sendBody("seda:in", (Object)"Bye World");
        this.template.sendBody("seda:in", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendMessageToLogUsingGroupInterval() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:in").to("log:hello?groupInterval=200&groupDelay=400&groupActiveOnly=false")).delay(50L).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(20);
        for (int i = 0; i < 20; ++i) {
            this.template.sendBody("seda:in", (Object)"Hello World");
        }
        this.assertMockEndpointsSatisfied();
    }
}

