/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.RouteDefinition;

public class PropertiesComponentOverridePropertiesTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testPropertiesComponentEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("{{hey}}")).to("mock:{{cool.result}}");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:extra").expectedMessageCount(1);
        this.getMockEndpoint("mock:hey").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("classpath:org/apache/camel/component/properties/myproperties.properties");
        context.addComponent("properties", (Component)pc);
        Properties extra = new Properties();
        extra.put("cool.result", "extra");
        extra.put("hey", "mock:hey");
        pc.setOverrideProperties(extra);
        return context;
    }
}

