/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ref;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;

public class RefInvalidTest
extends ContextTestSupport {
    private SimpleRegistry registry = new SimpleRegistry();

    public void testOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("ref:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testInvalid() throws Exception {
        try {
            this.template.sendBody("ref:xxx", (Object)"Hello World");
            RefInvalidTest.fail((String)"Should have thrown an exception");
        }
        catch (ResolveEndpointFailedException e) {
            RefInvalidTest.assertEquals((String)"Failed to resolve endpoint: ref://xxx due to: No bean could be found in the registry for: xxx of type: org.apache.camel.Endpoint", (String)e.getMessage());
            NoSuchBeanException cause = RefInvalidTest.assertIsInstanceOf(NoSuchBeanException.class, e.getCause());
            RefInvalidTest.assertEquals((String)"xxx", (String)cause.getName());
        }
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.registry);
        this.registry.put((Object)"foo", (Object)context.getEndpoint("seda:foo"));
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("ref:foo").routeId("foo").to("mock:result");
            }
        };
    }
}

