/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class SedaComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        SedaComponent comp = (SedaComponent)this.context.getComponent("seda", SedaComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("seda:foo?blockWhenFull=true");
        SedaComponentConfigurationAndDocumentationTest.assertEquals((Object)"true", (Object)conf.getParameter("blockWhenFull"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        SedaComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        SedaComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"timeout\": { \"type\": \"long\" }"));
        SedaComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"blockWhenFull\": { \"type\": \"boolean\" }"));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        if (SedaComponentConfigurationAndDocumentationTest.isJavaVersion("1.6")) {
            return;
        }
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("seda");
        SedaComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML if on Java 7", (Object)html);
    }
}

