/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.Iterator;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.QueueReference;
import org.apache.camel.component.seda.SedaComponent;

public class SedaComponentReferenceEndpointTest
extends ContextTestSupport {
    public void testSedaComponentReference() throws Exception {
        SedaComponent seda = (SedaComponent)this.context.getComponent("seda", SedaComponent.class);
        String key = seda.getQueueKey("seda://foo");
        SedaComponentReferenceEndpointTest.assertEquals((int)1, (int)((QueueReference)seda.getQueues().get(key)).getCount());
        SedaComponentReferenceEndpointTest.assertEquals((int)2, (int)this.numberOfReferences(seda));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo?blockWhenFull=true").routeId("foo2").to("mock:foo2");
            }
        });
        SedaComponentReferenceEndpointTest.assertEquals((int)2, (int)((QueueReference)seda.getQueues().get(key)).getCount());
        SedaComponentReferenceEndpointTest.assertEquals((int)3, (int)this.numberOfReferences(seda));
        this.context.stopRoute("foo");
        this.context.removeRoute("foo");
        SedaComponentReferenceEndpointTest.assertEquals((int)1, (int)((QueueReference)seda.getQueues().get(key)).getCount());
        SedaComponentReferenceEndpointTest.assertEquals((int)2, (int)this.numberOfReferences(seda));
        this.context.stopRoute("foo2");
        this.context.removeRoute("foo2");
        SedaComponentReferenceEndpointTest.assertNull(seda.getQueues().get(key));
        SedaComponentReferenceEndpointTest.assertEquals((int)1, (int)this.numberOfReferences(seda));
        key = seda.getQueueKey("seda://bar");
        SedaComponentReferenceEndpointTest.assertEquals((int)1, (int)((QueueReference)seda.getQueues().get(key)).getCount());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").routeId("foo").to("mock:foo");
                this.from("seda:bar").routeId("bar").to("mock:bar");
            }
        };
    }

    private int numberOfReferences(SedaComponent seda) {
        int num = 0;
        Iterator it = seda.getQueues().values().iterator();
        while (it.hasNext()) {
            num += ((QueueReference)it.next()).getCount();
        }
        return num;
    }
}

