/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class SedaPurgeWhenStoppingTest
extends ContextTestSupport {
    private final CountDownLatch latch = new CountDownLatch(1);

    public void testPurgeWhenStopping() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        for (int i = 0; i < 100; ++i) {
            this.template.sendBody("seda:foo", (Object)("Message " + i));
        }
        this.context.startRoute("myRoute");
        this.latch.await(5L, TimeUnit.SECONDS);
        this.context.stopRoute("myRoute");
        mock.setAssertPeriod(2000L);
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo?purgeWhenStopping=true").routeId("myRoute").noAutoStartup().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        SedaPurgeWhenStoppingTest.this.latch.countDown();
                        Thread.sleep(500L);
                    }
                })).to("mock:result");
            }
        };
    }
}

