/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;

public class SedaUnitOfWorkTest
extends ContextTestSupport {
    private static volatile String sync;
    private static volatile String lastOne;

    public void testSedaUOW() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).create();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        notify.matchesMockWaitTime();
        SedaUnitOfWorkTest.assertEquals((String)"onCompleteA", (String)sync);
        SedaUnitOfWorkTest.assertEquals((String)"onCompleteA", (String)lastOne);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                SedaUnitOfWorkTest.this.context.setTracing(Boolean.valueOf(true));
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyUOWProcessor("A"))).to("seda:foo");
                ((RouteDefinition)((RouteDefinition)this.from("seda:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals(null, (String)sync);
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        lastOne = "processor";
                    }
                })).to("mock:result");
            }
        };
    }

    private static final class MyUOWProcessor
    implements Processor {
        private String id;

        private MyUOWProcessor(String id) {
            this.id = id;
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getUnitOfWork().addSynchronization(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    sync = "onComplete" + MyUOWProcessor.this.id;
                    lastOne = sync;
                }

                public void onFailure(Exchange exchange) {
                    sync = "onFailure" + MyUOWProcessor.this.id;
                    lastOne = sync;
                }
            });
        }
    }
}

