/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.test;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;

public class TestEndpointTest
extends ContextTestSupport {
    private String expectedBody = "Hello World";

    public void testMocksAreValid() throws Exception {
        this.template.sendBody("seda:foo", (Object)this.expectedBody);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MyEndpoint my = new MyEndpoint("my:foo", (CamelContext)TestEndpointTest.this.context);
                TestEndpointTest.this.context.addEndpoint("my:foo", (Endpoint)my);
                this.from("seda:foo").to("test:my:foo");
            }
        };
    }

    private final class MyEndpoint
    extends DefaultEndpoint {
        private MyEndpoint(String endpointUri, CamelContext camelContext) {
        }

        public Producer createProducer() throws Exception {
            return null;
        }

        public Consumer createConsumer(final Processor processor) throws Exception {
            return new Consumer(){

                public Endpoint getEndpoint() {
                    return MyEndpoint.this;
                }

                public void start() throws Exception {
                    DefaultExchange exchange = new DefaultExchange(this.getEndpoint());
                    exchange.getIn().setBody((Object)TestEndpointTest.this.expectedBody);
                    processor.process((Exchange)exchange);
                }

                public void stop() throws Exception {
                }
            };
        }

        public boolean isSingleton() {
            return true;
        }
    }
}

