/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class TimerWithTimeOptionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testFiredInFutureWithTPattern() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Date future = new Date(new Date().getTime() + 2000L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                String time = sdf.format(future);
                this.fromF("timer://foo?time=%s", new Object[]{time}).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    public void testFiredInFutureWithTPatternNoPeriod() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Date future = new Date(new Date().getTime() + 2000L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                String time = sdf.format(future);
                this.fromF("timer://foo?period=0&time=%s", new Object[]{time}).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    public void testFiredInFutureWithTPatternFixedRate() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Date future = new Date(new Date().getTime() + 2000L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                String time = sdf.format(future);
                this.fromF("timer://foo?fixedRate=true&time=%s", new Object[]{time}).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    public void testFiredInFutureWithoutTPattern() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Date future = new Date(new Date().getTime() + 2000L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = sdf.format(future);
                this.fromF("timer://foo?time=%s", new Object[]{time}).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    public void testFiredInFutureWithoutTPatternNoPeriod() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Date future = new Date(new Date().getTime() + 2000L);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = sdf.format(future);
                this.fromF("timer://foo?period=0&time=%s", new Object[]{time}).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    public void testFiredInFutureCustomPattern() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Date future = new Date(new Date().getTime() + 2000L);
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                String time = sdf.format(future);
                this.fromF("timer://foo?time=%s&pattern=dd-MM-yyyy HH:mm:ss", new Object[]{time}).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    public void testFiredInFutureCustomPatternNoPeriod() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Date future = new Date(new Date().getTime() + 2000L);
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                String time = sdf.format(future);
                this.fromF("timer://foo?period=0&time=%s&pattern=dd-MM-yyyy HH:mm:ss", new Object[]{time}).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
    }

    public void testFiredInFutureIllegalTime() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.fromF("timer://foo?time=%s", new Object[]{"20090101"}).to("mock:result");
            }
        });
        try {
            this.context.start();
            TimerWithTimeOptionTest.fail((String)"Should throw an exception");
        }
        catch (FailedToCreateRouteException e) {
            TimerWithTimeOptionTest.assertIsInstanceOf(ParseException.class, e.getCause().getCause());
        }
    }
}

