/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.camel.converter.CollectionConverter;
import org.apache.camel.util.CaseInsensitiveMap;

public class CollectionConverterTest
extends TestCase {
    private static final List<String> SMURFS = Arrays.asList("Papa smurf", "Smurfette", "Hefty smurf", "Jokey smurf");

    public void testIteratorToList() throws Exception {
        this.assertSmurfs(CollectionConverter.toArrayList(SMURFS.iterator()));
    }

    public void testIterableToList() throws Exception {
        this.assertSmurfs(CollectionConverter.toList((Iterable)new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return SMURFS.iterator();
            }
        }));
        CollectionConverterTest.assertSame(SMURFS, (Object)CollectionConverter.toList(SMURFS));
    }

    private void assertSmurfs(Collection<String> result) {
        CollectionConverterTest.assertEquals((int)SMURFS.size(), (int)result.size());
        for (String key : result) {
            CollectionConverterTest.assertTrue((boolean)SMURFS.contains(key));
        }
    }

    public void testToArray() {
        CollectionConverterTest.assertEquals(null, (Object)CollectionConverter.toArray(null));
        Object[] data = CollectionConverter.toArray(SMURFS);
        CollectionConverterTest.assertEquals((int)4, (int)data.length);
    }

    public void testToList() {
        List out = CollectionConverter.toList(SMURFS);
        CollectionConverterTest.assertEquals((int)4, (int)out.size());
    }

    public void testToSet() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        Set out = CollectionConverter.toSet(map);
        CollectionConverterTest.assertEquals((int)1, (int)out.size());
    }

    public void testToHashMap() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("foo", "bar");
        HashMap out = CollectionConverter.toHashMap((Map)map);
        CollectionConverterTest.assertEquals((int)1, (int)out.size());
    }

    public void testToHashtable() {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("foo", "bar");
        Hashtable out = CollectionConverter.toHashtable((Map)map);
        CollectionConverterTest.assertEquals((int)1, (int)out.size());
    }

    public void testToProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        Properties prop = CollectionConverter.toProperties(map);
        CollectionConverterTest.assertNotNull((Object)prop);
        CollectionConverterTest.assertEquals((int)1, (int)prop.size());
        CollectionConverterTest.assertEquals((Object)"bar", (Object)prop.get("foo"));
    }
}

