/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.camel.converter.ObjectConverter;

public class ObjectConverterTest
extends TestCase {
    public void testIsCollection() {
        ObjectConverterTest.assertEquals((boolean)false, (boolean)ObjectConverter.isCollection((Object)"String"));
        ObjectConverterTest.assertEquals((boolean)false, (boolean)ObjectConverter.isCollection(null));
        ObjectConverterTest.assertEquals((boolean)true, (boolean)ObjectConverter.isCollection(new ArrayList()));
        ObjectConverterTest.assertEquals((boolean)true, (boolean)ObjectConverter.isCollection((Object)new String[]{"foo", "bar"}));
    }

    public void testIterator() {
        Iterator it = ObjectConverter.iterator((Object)"Claus,Jonathan");
        ObjectConverterTest.assertEquals((Object)"Claus", it.next());
        ObjectConverterTest.assertEquals((Object)"Jonathan", it.next());
        ObjectConverterTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testToByte() {
        ObjectConverterTest.assertEquals((Object)Byte.valueOf("4"), (Object)ObjectConverter.toByte((Object)Byte.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Byte.valueOf("4"), (Object)ObjectConverter.toByte((Object)Integer.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Byte.valueOf("4"), (Object)ObjectConverter.toByte((Object)"4"));
        ObjectConverterTest.assertEquals(null, (Object)ObjectConverter.toByte((Object)new Date()));
    }

    public void testToClass() {
        ObjectConverterTest.assertEquals(String.class, (Object)ObjectConverter.toClass(String.class, null));
        ObjectConverterTest.assertEquals(String.class, (Object)ObjectConverter.toClass((Object)"java.lang.String", null));
        ObjectConverterTest.assertEquals(null, (Object)ObjectConverter.toClass((Object)new Integer(4), null));
        ObjectConverterTest.assertEquals(null, (Object)ObjectConverter.toClass((Object)"foo.Bar", null));
    }

    public void testToShort() {
        ObjectConverterTest.assertEquals((Object)Short.valueOf("4"), (Object)ObjectConverter.toShort((Object)Short.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Short.valueOf("4"), (Object)ObjectConverter.toShort((Object)Integer.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Short.valueOf("4"), (Object)ObjectConverter.toShort((Object)"4"));
        ObjectConverterTest.assertEquals(null, (Object)ObjectConverter.toShort((Object)new Date()));
        ObjectConverterTest.assertEquals((Object)Short.valueOf("0"), (Object)ObjectConverter.toShort((Object)Double.NaN));
        ObjectConverterTest.assertEquals((Object)Short.valueOf("0"), (Object)ObjectConverter.toShort((Object)Float.valueOf(Float.NaN)));
        ObjectConverterTest.assertEquals((Object)Short.valueOf("4"), (Object)ObjectConverter.toShort((Object)Short.valueOf("4")));
    }

    public void testToInteger() {
        ObjectConverterTest.assertEquals((Object)Integer.valueOf("4"), (Object)ObjectConverter.toInteger((Object)Integer.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Integer.valueOf("4"), (Object)ObjectConverter.toInteger((Object)Long.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Integer.valueOf("4"), (Object)ObjectConverter.toInteger((String)"4"));
        ObjectConverterTest.assertEquals(null, (Object)ObjectConverter.toInteger((Object)new Date()));
        ObjectConverterTest.assertEquals((Object)Integer.valueOf("0"), (Object)ObjectConverter.toInteger((Object)Double.NaN));
        ObjectConverterTest.assertEquals((Object)Integer.valueOf("0"), (Object)ObjectConverter.toInteger((Object)Float.valueOf(Float.NaN)));
        ObjectConverterTest.assertEquals((Object)Integer.valueOf("4"), (Object)ObjectConverter.toInteger((Object)Integer.valueOf("4")));
    }

    public void testToLong() {
        ObjectConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)ObjectConverter.toLong((Object)Long.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)ObjectConverter.toLong((Object)Integer.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)ObjectConverter.toLong((String)"4"));
        ObjectConverterTest.assertEquals(null, (Object)ObjectConverter.toLong((Object)new Date()));
        ObjectConverterTest.assertEquals((Object)Long.valueOf("0"), (Object)ObjectConverter.toLong((Object)Double.NaN));
        ObjectConverterTest.assertEquals((Object)Long.valueOf("0"), (Object)ObjectConverter.toLong((Object)Float.valueOf(Float.NaN)));
        ObjectConverterTest.assertEquals((Object)Long.valueOf("4"), (Object)ObjectConverter.toLong((Object)Long.valueOf("4")));
    }

    public void testToFloat() {
        ObjectConverterTest.assertEquals((Object)Float.valueOf("4"), (Object)ObjectConverter.toFloat((Object)Float.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Float.valueOf("4"), (Object)ObjectConverter.toFloat((Object)Integer.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Float.valueOf("4"), (Object)ObjectConverter.toFloat((String)"4"));
        ObjectConverterTest.assertEquals(null, (Object)ObjectConverter.toFloat((Object)new Date()));
        ObjectConverterTest.assertEquals((Object)Float.valueOf(Float.NaN), (Object)ObjectConverter.toFloat((Object)Double.NaN));
        ObjectConverterTest.assertEquals((Object)Float.valueOf(Float.NaN), (Object)ObjectConverter.toFloat((Object)Float.valueOf(Float.NaN)));
        ObjectConverterTest.assertEquals((Object)Float.valueOf("4"), (Object)ObjectConverter.toFloat((Object)Float.valueOf("4")));
    }

    public void testToDouble() {
        ObjectConverterTest.assertEquals((Object)Double.valueOf("4"), (Object)ObjectConverter.toDouble((Object)Double.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Double.valueOf("4"), (Object)ObjectConverter.toDouble((Object)Integer.valueOf("4")));
        ObjectConverterTest.assertEquals((Object)Double.valueOf("4"), (Object)ObjectConverter.toDouble((String)"4"));
        ObjectConverterTest.assertEquals(null, (Object)ObjectConverter.toDouble((Object)new Date()));
        ObjectConverterTest.assertEquals((Object)Double.NaN, (Object)ObjectConverter.toDouble((Object)Double.NaN));
        ObjectConverterTest.assertEquals((Object)Double.NaN, (Object)ObjectConverter.toDouble((Object)Float.valueOf(Float.NaN)));
        ObjectConverterTest.assertEquals((Object)Double.valueOf("4"), (Object)ObjectConverter.toDouble((Object)Double.valueOf("4")));
    }

    public void testToString() {
        ObjectConverterTest.assertEquals((String)"ABC", (String)ObjectConverter.toString((StringBuffer)new StringBuffer("ABC")));
        ObjectConverterTest.assertEquals((String)"ABC", (String)ObjectConverter.toString((StringBuilder)new StringBuilder("ABC")));
        ObjectConverterTest.assertEquals((String)"", (String)ObjectConverter.toString((StringBuffer)new StringBuffer("")));
        ObjectConverterTest.assertEquals((String)"", (String)ObjectConverter.toString((StringBuilder)new StringBuilder("")));
    }

    public void testNaN() throws Exception {
        ObjectConverterTest.assertEquals((Object)Double.NaN, (Object)ObjectConverter.toDouble((Object)Double.NaN));
        ObjectConverterTest.assertEquals((Object)Double.NaN, (Object)ObjectConverter.toDouble((Object)Float.valueOf(Float.NaN)));
        ObjectConverterTest.assertEquals((Object)Float.valueOf(Float.NaN), (Object)ObjectConverter.toFloat((Object)Double.NaN));
        ObjectConverterTest.assertEquals((Object)Float.valueOf(Float.NaN), (Object)ObjectConverter.toFloat((Object)Float.valueOf(Float.NaN)));
    }
}

