/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.InputStream;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.converter.jaxp.DomConverter;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class DomConverterTest
extends ContextTestSupport {
    public void testDomConverterToString() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>world!</hello>");
        String s = new DomConverter().toString(document.getChildNodes(), null);
        DomConverterTest.assertEquals((String)"<hello>world!</hello>", (String)s);
    }

    public void testDomConverterToBytes() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>world!</hello>");
        byte[] bytes = new DomConverter().toByteArray(document.getChildNodes(), null);
        DomConverterTest.assertTrue((String)"Should be equal", (boolean)ObjectHelper.equalByteArray((byte[])"<hello>world!</hello>".getBytes("UTF-8"), (byte[])bytes));
    }

    public void testDomConverterToNoAssicBytes() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>\u99f1\u99ddb\u00e4r</foo>");
        byte[] bytes = new DomConverter().toByteArray(document.getChildNodes(), null);
        DomConverterTest.assertTrue((String)"Should be equal", (boolean)ObjectHelper.equalByteArray((byte[])"<foo>\u99f1\u99ddb\u00e4r</foo>".getBytes("UTF-8"), (byte[])bytes));
    }

    public void testDomConverterToInteger() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>47</hello>");
        Integer number = DomConverter.toInteger((NodeList)document.getChildNodes());
        DomConverterTest.assertEquals((int)47, (int)number);
    }

    public void testDomConverterToLong() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>47</hello>");
        Long number = DomConverter.toLong((NodeList)document.getChildNodes());
        DomConverterTest.assertEquals((long)47L, (long)number);
    }

    public void testDomConverterToList() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo><hello>Hello World</hello><bye>Bye Camel</bye></foo>");
        List list = DomConverter.toList((NodeList)document.getElementsByTagName("foo"));
        DomConverterTest.assertEquals((int)1, (int)list.size());
        NodeList nl = DomConverterTest.assertIsInstanceOf(NodeList.class, list.get(0));
        List sub = DomConverter.toList((NodeList)nl);
        DomConverterTest.assertEquals((int)2, (int)sub.size());
        DomConverterTest.assertEquals((String)"<hello>Hello World</hello>", (String)new DomConverter().toString((NodeList)sub.get(0), null));
        DomConverterTest.assertEquals((String)"<bye>Bye Camel</bye>", (String)new DomConverter().toString((NodeList)sub.get(1), null));
    }

    public void testDomConverterToInputStream() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><hello>world!</hello>");
        InputStream is = new DomConverter().toInputStream(document.getChildNodes(), null);
        DomConverterTest.assertEquals((String)"<hello>world!</hello>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)is)));
    }
}

