/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.fabric;

import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.fabric.FabricTracerEventMessage;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.DefaultManagementNamingStrategy;
import org.apache.camel.model.RouteDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class FabricTracerTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultManagementNamingStrategy naming = (DefaultManagementNamingStrategy)context.getManagementStrategy().getManagementNamingStrategy();
        naming.setHostName("localhost");
        naming.setDomainName("org.apache.camel");
        return context;
    }

    protected MBeanServer getMBeanServer() {
        return this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
    }

    @Override
    protected boolean useJmx() {
        return true;
    }

    public void testFabricTracerEventMessage() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = null;
        Set<ObjectName> names = mbeanServer.queryNames(ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=fabric,*"), null);
        for (ObjectName name : names) {
            if (!name.toString().contains("FabricTracer")) continue;
            on = name;
            break;
        }
        FabricTracerTest.assertNotNull(on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        FabricTracerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        Integer size = (Integer)mbeanServer.getAttribute(on, "QueueSize");
        FabricTracerTest.assertEquals((String)"Should be 10", (int)10, (int)size);
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:foo").getReceivedExchanges();
        List events = (List)mbeanServer.invoke(on, "dumpTracedMessages", new Object[]{"foo"}, new String[]{"java.lang.String"});
        FabricTracerTest.assertNotNull((Object)events);
        FabricTracerTest.assertEquals((int)2, (int)events.size());
        FabricTracerEventMessage event1 = (FabricTracerEventMessage)events.get(0);
        FabricTracerTest.assertEquals((String)"foo", (String)event1.getToNode());
        FabricTracerTest.assertEquals((String)("<message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\">\n" + "<body type=\"java.lang.String\">Hello World</body>\n" + "</message>"), (String)event1.getMessageAsXml());
        FabricTracerEventMessage event2 = (FabricTracerEventMessage)events.get(1);
        FabricTracerTest.assertEquals((String)"foo", (String)event2.getToNode());
        FabricTracerTest.assertEquals((String)("<message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\">\n" + "<body type=\"java.lang.String\">Bye World</body>\n" + "</message>"), (String)event2.getMessageAsXml());
    }

    public void testFabricTracerEventMessageAsXml() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = null;
        Set<ObjectName> names = mbeanServer.queryNames(ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=fabric,*"), null);
        for (ObjectName name : names) {
            if (!name.toString().contains("FabricTracer")) continue;
            on = name;
            break;
        }
        FabricTracerTest.assertNotNull(on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        FabricTracerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        Integer size = (Integer)mbeanServer.getAttribute(on, "QueueSize");
        FabricTracerTest.assertEquals((String)"Should be 10", (int)10, (int)size);
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        String events = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"foo"}, new String[]{"java.lang.String"});
        FabricTracerTest.assertNotNull((Object)events);
        this.log.info(events);
        Document dom = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)events);
        FabricTracerTest.assertNotNull((Object)dom);
        NodeList list = dom.getElementsByTagName("fabricTracerEventMessage");
        FabricTracerTest.assertEquals((int)2, (int)list.getLength());
    }

    public void testFabricTracerEventMessageDumpAll() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = null;
        Set<ObjectName> names = mbeanServer.queryNames(ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=fabric,*"), null);
        for (ObjectName name : names) {
            if (!name.toString().contains("FabricTracer")) continue;
            on = name;
            break;
        }
        FabricTracerTest.assertNotNull(on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        FabricTracerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        List fooExchanges = this.getMockEndpoint("mock:foo").getReceivedExchanges();
        List barExchanges = this.getMockEndpoint("mock:bar").getReceivedExchanges();
        List events = (List)mbeanServer.invoke(on, "dumpAllTracedMessages", null, null);
        FabricTracerTest.assertNotNull((Object)events);
        FabricTracerTest.assertEquals((int)6, (int)events.size());
        FabricTracerEventMessage event0 = (FabricTracerEventMessage)events.get(0);
        FabricTracerTest.assertEquals((String)"route1", (String)event0.getToNode());
        FabricTracerTest.assertEquals((String)("<message exchangeId=\"" + ((Exchange)fooExchanges.get(0)).getExchangeId() + "\">\n" + "<body type=\"java.lang.String\">Hello World</body>\n" + "</message>"), (String)event0.getMessageAsXml());
        FabricTracerEventMessage event1 = (FabricTracerEventMessage)events.get(1);
        FabricTracerTest.assertEquals((String)"foo", (String)event1.getToNode());
        FabricTracerTest.assertEquals((String)("<message exchangeId=\"" + ((Exchange)fooExchanges.get(0)).getExchangeId() + "\">\n" + "<body type=\"java.lang.String\">Hello World</body>\n" + "</message>"), (String)event1.getMessageAsXml());
        FabricTracerEventMessage event2 = (FabricTracerEventMessage)events.get(2);
        FabricTracerTest.assertEquals((String)"bar", (String)event2.getToNode());
        FabricTracerTest.assertEquals((String)("<message exchangeId=\"" + ((Exchange)barExchanges.get(0)).getExchangeId() + "\">\n" + "<body type=\"java.lang.String\">Hello World</body>\n" + "</message>"), (String)event2.getMessageAsXml());
        FabricTracerEventMessage event3 = (FabricTracerEventMessage)events.get(3);
        FabricTracerTest.assertEquals((String)"route1", (String)event3.getToNode());
        FabricTracerTest.assertEquals((String)("<message exchangeId=\"" + ((Exchange)fooExchanges.get(1)).getExchangeId() + "\">\n" + "<body type=\"java.lang.String\">Bye World</body>\n" + "</message>"), (String)event3.getMessageAsXml());
        FabricTracerEventMessage event4 = (FabricTracerEventMessage)events.get(4);
        FabricTracerTest.assertEquals((String)"foo", (String)event4.getToNode());
        FabricTracerTest.assertEquals((String)("<message exchangeId=\"" + ((Exchange)fooExchanges.get(1)).getExchangeId() + "\">\n" + "<body type=\"java.lang.String\">Bye World</body>\n" + "</message>"), (String)event3.getMessageAsXml());
        FabricTracerEventMessage event5 = (FabricTracerEventMessage)events.get(5);
        FabricTracerTest.assertEquals((String)"bar", (String)event5.getToNode());
        FabricTracerTest.assertEquals((String)("<message exchangeId=\"" + ((Exchange)barExchanges.get(1)).getExchangeId() + "\">\n" + "<body type=\"java.lang.String\">Bye World</body>\n" + "</message>"), (String)event4.getMessageAsXml());
    }

    public void testFabricTracerEventMessageDumpAllAsXml() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = null;
        Set<ObjectName> names = mbeanServer.queryNames(ObjectName.getInstance("org.apache.camel:context=localhost/camel-1,type=fabric,*"), null);
        for (ObjectName name : names) {
            if (!name.toString().contains("FabricTracer")) continue;
            on = name;
            break;
        }
        FabricTracerTest.assertNotNull(on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        FabricTracerTest.assertEquals((String)"Should not be enabled", (Object)Boolean.FALSE, (Object)enabled);
        mbeanServer.setAttribute(on, new Attribute("Enabled", Boolean.TRUE));
        this.getMockEndpoint("mock:foo").expectedMessageCount(2);
        this.getMockEndpoint("mock:bar").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        String events = (String)mbeanServer.invoke(on, "dumpAllTracedMessagesAsXml", null, null);
        FabricTracerTest.assertNotNull((Object)events);
        this.log.info(events);
        Document dom = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)events);
        FabricTracerTest.assertNotNull((Object)dom);
        NodeList list = dom.getElementsByTagName("fabricTracerEventMessage");
        FabricTracerTest.assertEquals((int)6, (int)list.getLength());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                FabricTracerTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

