/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import junit.framework.TestCase;
import org.apache.camel.impl.ActiveMQUuidGenerator;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQUuidGeneratorTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQUuidGeneratorTest.class);

    public void testGenerateUUID() {
        ActiveMQUuidGenerator uuidGenerator = new ActiveMQUuidGenerator();
        String firstUUID = uuidGenerator.generateUuid();
        String secondUUID = uuidGenerator.generateUuid();
        ActiveMQUuidGeneratorTest.assertNotSame((Object)firstUUID, (Object)secondUUID);
    }

    public void testPerformance() {
        ActiveMQUuidGenerator uuidGenerator = new ActiveMQUuidGenerator();
        StopWatch watch = new StopWatch();
        LOG.info("First id: " + uuidGenerator.generateUuid());
        for (int i = 0; i < 500000; ++i) {
            uuidGenerator.generateUuid();
        }
        LOG.info("Last id:  " + uuidGenerator.generateUuid());
        LOG.info("Took " + TimeUtils.printDuration((double)watch.stop()));
    }

    public void testSanitizeHostName() throws Exception {
        ActiveMQUuidGeneratorTest.assertEquals((String)"somehost.lan", (String)ActiveMQUuidGenerator.sanitizeHostName((String)"somehost.lan"));
        ActiveMQUuidGeneratorTest.assertEquals((String)"otherhost.lan", (String)ActiveMQUuidGenerator.sanitizeHostName((String)"other\u0e08host.lan"));
    }
}

