/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class CamelContextAddRouteDefinitionsFromXmlTest
extends ContextTestSupport {
    protected JAXBContext jaxbContext;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.jaxbContext = CamelContextAddRouteDefinitionsFromXmlTest.createJaxbContext();
    }

    public static JAXBContext createJaxbContext() throws JAXBException {
        return JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer");
    }

    protected Object parseUri(String uri) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        URL resource = ((Object)((Object)this)).getClass().getResource(uri);
        CamelContextAddRouteDefinitionsFromXmlTest.assertNotNull((String)("Cannot find resource on the classpath: " + uri), (Object)resource);
        Object value = unmarshaller.unmarshal(resource);
        return value;
    }

    protected RouteDefinition loadRoute(String uri) throws Exception {
        Object route = this.parseUri(uri);
        return CamelContextAddRouteDefinitionsFromXmlTest.assertIsInstanceOf(RouteDefinition.class, route);
    }

    public void testAddRouteDefinitionsFromXml() throws Exception {
        RouteDefinition route = this.loadRoute("route1.xml");
        CamelContextAddRouteDefinitionsFromXmlTest.assertNotNull((Object)route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((String)"foo", (String)route.getId());
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        CamelContextAddRouteDefinitionsFromXmlTest.assertTrue((String)"Route should be started", (boolean)this.context.getRouteStatus("foo").isStarted());
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testRemoveRouteDefinitionsFromXml() throws Exception {
        RouteDefinition route = this.loadRoute("route1.xml");
        CamelContextAddRouteDefinitionsFromXmlTest.assertNotNull((Object)route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((String)"foo", (String)route.getId());
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)1, (int)this.context.getRouteDefinitions().size());
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        CamelContextAddRouteDefinitionsFromXmlTest.assertTrue((String)"Route should be started", (boolean)this.context.getRouteStatus("foo").isStarted());
        this.context.removeRouteDefinition(route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)0, (int)this.context.getRoutes().size());
        CamelContextAddRouteDefinitionsFromXmlTest.assertNull((Object)this.context.getRouteStatus("foo"));
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)0, (int)this.context.getRouteDefinitions().size());
    }

    public void testAddRouteDefinitionsFromXml2() throws Exception {
        RouteDefinition route = this.loadRoute("route2.xml");
        CamelContextAddRouteDefinitionsFromXmlTest.assertNotNull((Object)route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((String)"foo", (String)route.getId());
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        CamelContextAddRouteDefinitionsFromXmlTest.assertTrue((String)"Route should be stopped", (boolean)this.context.getRouteStatus("foo").isStopped());
        this.context.startRoute("foo");
        CamelContextAddRouteDefinitionsFromXmlTest.assertTrue((String)"Route should be started", (boolean)this.context.getRouteStatus("foo").isStarted());
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testAddRouteDefinitionsFromXmlIsPrepared() throws Exception {
        RouteDefinition route = this.loadRoute("route1.xml");
        CamelContextAddRouteDefinitionsFromXmlTest.assertNotNull((Object)route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((String)"foo", (String)route.getId());
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        CamelContextAddRouteDefinitionsFromXmlTest.assertTrue((String)"Route should be started", (boolean)this.context.getRouteStatus("foo").isStarted());
        CamelContextAddRouteDefinitionsFromXmlTest.assertNotNull((Object)"Parent should be set on outputs");
        route = this.context.getRouteDefinition("foo");
        for (ProcessorDefinition output : route.getOutputs()) {
            CamelContextAddRouteDefinitionsFromXmlTest.assertNotNull((String)"Parent should be set on output", (Object)output.getParent());
            CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((Object)route, (Object)output.getParent());
        }
    }

    public void testAddRouteDefinitionsFromXml3() throws Exception {
        RouteDefinition route = this.loadRoute("route3.xml");
        CamelContextAddRouteDefinitionsFromXmlTest.assertNotNull((Object)route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((String)"foo", (String)route.getId());
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)0, (int)this.context.getRoutes().size());
        this.context.addRouteDefinition(route);
        CamelContextAddRouteDefinitionsFromXmlTest.assertEquals((int)1, (int)this.context.getRoutes().size());
        CamelContextAddRouteDefinitionsFromXmlTest.assertTrue((String)"Route should be started", (boolean)this.context.getRouteStatus("foo").isStarted());
        this.getMockEndpoint("mock:foo").whenExchangeReceived(2, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new IllegalArgumentException("Damn"));
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }
}

