/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Consume;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Produce;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.PropertyInject;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.impl.CamelPostProcessorHelper;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.ObjectHelper;

public class CamelPostProcessorHelperTest
extends ContextTestSupport {
    private MySynchronization mySynchronization = new MySynchronization();
    private Properties myProp = new Properties();

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myProp", (Object)this.myProp);
        return jndi;
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        PropertiesComponent pc = (PropertiesComponent)context.getComponent("properties", PropertiesComponent.class);
        pc.setLocation("ref:myProp");
        return context;
    }

    public void testConstructor() {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper();
        CamelPostProcessorHelperTest.assertNull((Object)helper.getCamelContext());
        helper.setCamelContext((CamelContext)this.context);
        CamelPostProcessorHelperTest.assertNotNull((Object)helper.getCamelContext());
    }

    public void testConstructorCamelContext() {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        CamelPostProcessorHelperTest.assertNotNull((Object)helper.getCamelContext());
    }

    public void testMatchContext() {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        CamelPostProcessorHelperTest.assertTrue((boolean)helper.matchContext(this.context.getName()));
        CamelPostProcessorHelperTest.assertFalse((boolean)helper.matchContext("foo"));
    }

    public void testConsume() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeBean my = new MyConsumeBean();
        Method method = my.getClass().getMethod("consumeSomething", String.class);
        helper.consumerInjection(method, (Object)my, "foo");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testConsumePrivate() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPrivateConsumeBean my = new MyPrivateConsumeBean();
        Method method = my.getClass().getDeclaredMethod("consumeSomethingPrivate", String.class);
        try {
            helper.consumerInjection(method, (Object)my, "foo");
            CamelPostProcessorHelperTest.fail((String)"Should have thrown exception");
        }
        catch (RuntimeCamelException e) {
            IllegalArgumentException iae = CamelPostProcessorHelperTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            CamelPostProcessorHelperTest.assertTrue((boolean)iae.getMessage().startsWith("The method private void"));
            CamelPostProcessorHelperTest.assertTrue((boolean)iae.getMessage().endsWith("(for example the method must be public)"));
        }
    }

    public void testConsumeSynchronization() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyConsumeAndSynchronizationBean my = new MyConsumeAndSynchronizationBean();
        Method method = my.getClass().getMethod("consumeSomething", String.class, Exchange.class);
        helper.consumerInjection(method, (Object)my, "foo");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(500L);
        CamelPostProcessorHelperTest.assertTrue((String)"Should have invoked onDone", (boolean)this.mySynchronization.isOnDone());
    }

    public void testProduceSynchronization() throws Exception {
        MyProduceAndSynchronizationBean my = new MyProduceAndSynchronizationBean();
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        Producer producer = helper.createInjectionProducer(this.context.getEndpoint("mock:result"), (Object)my, "foo");
        my.setProducer(producer);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        my.produceSomething("Hello World");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(500L);
        CamelPostProcessorHelperTest.assertTrue((String)"Should have invoked onDone", (boolean)this.mySynchronization.isOnDone());
    }

    public void testEndpointInjectProducerTemplate() throws Exception {
        Class<?>[] parameterTypes;
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectBeanProducerTemplate bean = new MyEndpointInjectBeanProducerTemplate();
        Method method = bean.getClass().getMethod("setProducer", ProducerTemplate.class);
        EndpointInject endpointInject = method.getAnnotation(EndpointInject.class);
        for (Class<?> type : parameterTypes = method.getParameterTypes()) {
            String propertyName = ObjectHelper.getPropertyName((Method)method);
            Object value = helper.getInjectionValue(type, endpointInject.uri(), endpointInject.ref(), endpointInject.property(), propertyName, (Object)bean, "foo");
            ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        CamelPostProcessorHelperTest.assertNotNull((Object)bean.getProducer());
        bean.send("Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testEndpointInjectProducer() throws Exception {
        Class<?>[] parameterTypes;
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointBeanProducer bean = new MyEndpointBeanProducer();
        Method method = bean.getClass().getMethod("setProducer", Producer.class);
        EndpointInject endpointInject = method.getAnnotation(EndpointInject.class);
        for (Class<?> type : parameterTypes = method.getParameterTypes()) {
            String propertyName = ObjectHelper.getPropertyName((Method)method);
            Object value = helper.getInjectionValue(type, endpointInject.uri(), endpointInject.ref(), endpointInject.property(), propertyName, (Object)bean, "foo");
            ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        CamelPostProcessorHelperTest.assertNotNull((Object)bean.getProducer());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        bean.send((Exchange)exchange);
        this.assertMockEndpointsSatisfied();
    }

    public void testEndpointInjectPollingConsumer() throws Exception {
        Class<?>[] parameterTypes;
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointBeanPollingConsumer bean = new MyEndpointBeanPollingConsumer();
        Method method = bean.getClass().getMethod("setConsumer", PollingConsumer.class);
        EndpointInject endpointInject = method.getAnnotation(EndpointInject.class);
        for (Class<?> type : parameterTypes = method.getParameterTypes()) {
            String propertyName = ObjectHelper.getPropertyName((Method)method);
            Object value = helper.getInjectionValue(type, endpointInject.uri(), endpointInject.ref(), endpointInject.property(), propertyName, (Object)bean, "foo");
            ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
        }
        this.template.sendBody("seda:foo", (Object)"Hello World");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        CamelPostProcessorHelperTest.assertNotNull((Object)bean.getConsumer());
        Exchange exchange = bean.consume();
        this.template.send("mock:result", exchange);
        this.assertMockEndpointsSatisfied();
    }

    public void testEndpointInjectProducerTemplateField() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectProducerTemplate bean = new MyEndpointInjectProducerTemplate();
        Field field = bean.getClass().getField("producer");
        EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
        Class<?> type = field.getType();
        String propertyName = "producer";
        Object value = helper.getInjectionValue(type, endpointInject.uri(), endpointInject.ref(), endpointInject.property(), propertyName, (Object)bean, "foo");
        field.set(bean, value);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        bean.send((Exchange)exchange);
        this.assertMockEndpointsSatisfied();
    }

    public void testEndpointInjectProducerTemplateFieldNoDefaultEndpoint() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectProducerTemplateNoDefaultEndpoint bean = new MyEndpointInjectProducerTemplateNoDefaultEndpoint();
        Field field = bean.getClass().getField("producer");
        EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
        Class<?> type = field.getType();
        String propertyName = "producer";
        Object value = helper.getInjectionValue(type, endpointInject.uri(), endpointInject.ref(), endpointInject.property(), propertyName, (Object)bean, "foo");
        field.set(bean, value);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        bean.send((Exchange)exchange);
        this.assertMockEndpointsSatisfied();
    }

    public void testEndpointInjectProducerTemplateFieldNameUnknown() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectProducerTemplateNameUnknown bean = new MyEndpointInjectProducerTemplateNameUnknown();
        Field field = bean.getClass().getField("producer");
        EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
        Class<?> type = field.getType();
        String propertyName = "producer";
        try {
            helper.getInjectionValue(type, endpointInject.uri(), endpointInject.ref(), endpointInject.property(), propertyName, (Object)bean, "foo");
            CamelPostProcessorHelperTest.fail((String)"Should throw exception");
        }
        catch (NoSuchBeanException e) {
            CamelPostProcessorHelperTest.assertEquals((String)"No bean could be found in the registry for: unknown of type: org.apache.camel.Endpoint", (String)e.getMessage());
        }
    }

    public void testEndpointInjectProducerTemplateFieldUrlUnknown() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointInjectProducerTemplateUrlUnknown bean = new MyEndpointInjectProducerTemplateUrlUnknown();
        Field field = bean.getClass().getField("producer");
        EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
        Class<?> type = field.getType();
        String propertyName = "producer";
        try {
            helper.getInjectionValue(type, endpointInject.uri(), endpointInject.ref(), endpointInject.property(), propertyName, (Object)bean, "foo");
            CamelPostProcessorHelperTest.fail((String)"Should throw exception");
        }
        catch (ResolveEndpointFailedException e) {
            CamelPostProcessorHelperTest.assertEquals((String)"Failed to resolve endpoint: xxx://foo due to: No component found with scheme: xxx", (String)e.getMessage());
        }
    }

    public void testEndpointInjectBothUriAndRef() throws Exception {
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyEndpointBothUriAndRef bean = new MyEndpointBothUriAndRef();
        Field field = bean.getClass().getField("producer");
        EndpointInject endpointInject = field.getAnnotation(EndpointInject.class);
        Class<?> type = field.getType();
        String propertyName = "producer";
        try {
            helper.getInjectionValue(type, endpointInject.uri(), endpointInject.ref(), endpointInject.property(), propertyName, (Object)bean, "foo");
            CamelPostProcessorHelperTest.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException e) {
            CamelPostProcessorHelperTest.assertEquals((String)"Both uri and name is provided, only either one is allowed: uri=seda:foo, ref=myEndpoint", (String)e.getMessage());
        }
    }

    public void testPropertyFieldInject() throws Exception {
        this.myProp.put("myTimeout", "2000");
        this.myProp.put("myApp", "Camel");
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPropertyFieldBean bean = new MyPropertyFieldBean();
        Field field = bean.getClass().getField("timeout");
        PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
        Class<?> type = field.getType();
        Object value = helper.getInjectionPropertyValue(type, propertyInject.value(), "", "timeout", (Object)bean, "foo");
        CamelPostProcessorHelperTest.assertEquals((Object)Integer.valueOf("2000"), (Object)Integer.valueOf("" + value));
        field = bean.getClass().getField("greeting");
        propertyInject = field.getAnnotation(PropertyInject.class);
        type = field.getType();
        value = helper.getInjectionPropertyValue(type, propertyInject.value(), "", "greeting", (Object)bean, "foo");
        CamelPostProcessorHelperTest.assertEquals((Object)"Hello Camel", (Object)value);
    }

    public void testPropertyFieldDefaultValueInject() throws Exception {
        this.myProp.put("myApp", "Camel");
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPropertyFieldBean bean = new MyPropertyFieldBean();
        Field field = bean.getClass().getField("timeout");
        PropertyInject propertyInject = field.getAnnotation(PropertyInject.class);
        Class<?> type = field.getType();
        Object value = helper.getInjectionPropertyValue(type, propertyInject.value(), "5000", "timeout", (Object)bean, "foo");
        CamelPostProcessorHelperTest.assertEquals((Object)Integer.valueOf("5000"), (Object)Integer.valueOf("" + value));
        field = bean.getClass().getField("greeting");
        propertyInject = field.getAnnotation(PropertyInject.class);
        type = field.getType();
        value = helper.getInjectionPropertyValue(type, propertyInject.value(), "", "greeting", (Object)bean, "foo");
        CamelPostProcessorHelperTest.assertEquals((Object)"Hello Camel", (Object)value);
    }

    public void testPropertyMethodInject() throws Exception {
        this.myProp.put("myTimeout", "2000");
        this.myProp.put("myApp", "Camel");
        CamelPostProcessorHelper helper = new CamelPostProcessorHelper((CamelContext)this.context);
        MyPropertyMethodBean bean = new MyPropertyMethodBean();
        Method method = bean.getClass().getMethod("setTimeout", Integer.TYPE);
        PropertyInject propertyInject = method.getAnnotation(PropertyInject.class);
        Class<?> type = method.getParameterTypes()[0];
        Object value = helper.getInjectionPropertyValue(type, propertyInject.value(), "", "timeout", (Object)bean, "foo");
        CamelPostProcessorHelperTest.assertEquals((Object)Integer.valueOf("2000"), (Object)Integer.valueOf("" + value));
        method = bean.getClass().getMethod("setGreeting", String.class);
        propertyInject = method.getAnnotation(PropertyInject.class);
        type = method.getParameterTypes()[0];
        value = helper.getInjectionPropertyValue(type, propertyInject.value(), "", "greeting", (Object)bean, "foo");
        CamelPostProcessorHelperTest.assertEquals((Object)"Hello Camel", (Object)value);
    }

    public class MyPropertyMethodBean {
        private int timeout;
        private String greeting;

        public String doSomething(String body) {
            return this.greeting + " " + body + " with timeout=" + this.timeout;
        }

        public int getTimeout() {
            return this.timeout;
        }

        @PropertyInject(value="myTimeout")
        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public String getGreeting() {
            return this.greeting;
        }

        @PropertyInject(value="Hello {{myApp}}")
        public void setGreeting(String greeting) {
            this.greeting = greeting;
        }
    }

    public class MyPropertyFieldDefaultValueBean {
        @PropertyInject(value="myTimeout", defaultValue="5000")
        public int timeout;
        @PropertyInject(value="Hello {{myApp}}")
        public String greeting;

        public String doSomething(String body) {
            return this.greeting + " " + body + " with timeout=" + this.timeout;
        }
    }

    public class MyPropertyFieldBean {
        @PropertyInject(value="myTimeout")
        public int timeout;
        @PropertyInject(value="Hello {{myApp}}")
        public String greeting;

        public String doSomething(String body) {
            return this.greeting + " " + body + " with timeout=" + this.timeout;
        }
    }

    public class MyPrivateConsumeBean {
        @Consume(uri="seda:foo")
        private void consumeSomethingPrivate(String body) {
            TestCase.assertEquals((String)"Hello World", (String)body);
            CamelPostProcessorHelperTest.this.template.sendBody("mock:result", (Object)body);
        }
    }

    public class MyEndpointBothUriAndRef {
        @EndpointInject(uri="seda:foo", ref="myEndpoint")
        public ProducerTemplate producer;

        public void send(Exchange exchange) throws Exception {
            this.producer.send(exchange);
        }
    }

    public class MyEndpointInjectProducerTemplateUrlUnknown {
        @EndpointInject(uri="xxx:foo")
        public ProducerTemplate producer;

        public void send(Exchange exchange) throws Exception {
            this.producer.send(exchange);
        }
    }

    public class MyEndpointInjectProducerTemplateNameUnknown {
        @EndpointInject(ref="unknown")
        public ProducerTemplate producer;

        public void send(Exchange exchange) throws Exception {
            this.producer.send(exchange);
        }
    }

    public class MyEndpointInjectProducerTemplateNoDefaultEndpoint {
        @EndpointInject
        public ProducerTemplate producer;

        public void send(Exchange exchange) throws Exception {
            this.producer.send("mock:result", exchange);
        }
    }

    public class MyEndpointInjectProducerTemplate {
        @EndpointInject(uri="mock:result")
        public ProducerTemplate producer;

        public void send(Exchange exchange) throws Exception {
            this.producer.send(exchange);
        }
    }

    public class MyEndpointBeanPollingConsumer {
        private PollingConsumer consumer;

        @EndpointInject(uri="seda:foo")
        public void setConsumer(PollingConsumer consumer) {
            this.consumer = consumer;
        }

        public PollingConsumer getConsumer() {
            return this.consumer;
        }

        public Exchange consume() throws Exception {
            return this.consumer.receive(1000L);
        }
    }

    public class MyEndpointBeanProducer {
        private Producer producer;

        @EndpointInject(uri="mock:result")
        public void setProducer(Producer producer) {
            this.producer = producer;
        }

        public Producer getProducer() {
            return this.producer;
        }

        public void send(Exchange exchange) throws Exception {
            this.producer.process(exchange);
        }
    }

    public class MyEndpointInjectBeanProducerTemplate {
        private ProducerTemplate producer;

        @EndpointInject(uri="mock:result")
        public void setProducer(ProducerTemplate producer) {
            this.producer = producer;
        }

        public ProducerTemplate getProducer() {
            return this.producer;
        }

        public void send(String message) {
            this.producer.sendBody((Object)message);
        }
    }

    private static class MySynchronization
    extends SynchronizationAdapter {
        private boolean onDone;

        private MySynchronization() {
        }

        public void onDone(Exchange exchange) {
            this.onDone = true;
        }

        public boolean isOnDone() {
            return this.onDone;
        }
    }

    public class MyProduceAndSynchronizationBean {
        @Produce(uri="mock:result")
        Producer producer;

        public void produceSomething(String body) throws Exception {
            TestCase.assertEquals((String)"Hello World", (String)body);
            Exchange exchange = this.producer.createExchange();
            exchange.addOnCompletion((Synchronization)CamelPostProcessorHelperTest.this.mySynchronization);
            exchange.getIn().setBody((Object)body);
            this.producer.process(exchange);
        }

        public void setProducer(Producer producer) {
            this.producer = producer;
        }
    }

    public class MyConsumeAndSynchronizationBean {
        @Consume(uri="seda:foo")
        public void consumeSomething(String body, Exchange exchange) {
            exchange.addOnCompletion((Synchronization)CamelPostProcessorHelperTest.this.mySynchronization);
            TestCase.assertEquals((String)"Hello World", (String)body);
            CamelPostProcessorHelperTest.this.template.sendBody("mock:result", (Object)body);
        }
    }

    public class MyConsumeBean {
        @Consume(uri="seda:foo")
        public void consumeSomething(String body) {
            TestCase.assertEquals((String)"Hello World", (String)body);
            CamelPostProcessorHelperTest.this.template.sendBody("mock:result", (Object)body);
        }
    }
}

