/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DefaultCamelContextSuspendResumeRouteTest
extends ContextTestSupport {
    public void testSuspendResume() throws Exception {
        DefaultCamelContextSuspendResumeRouteTest.assertFalse((boolean)this.context.isSuspended());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Suspending");
        this.resetMocks();
        mock.expectedMessageCount(0);
        this.context.suspend();
        this.template.sendBody("seda:foo", (Object)"B");
        mock.assertIsSatisfied(1000L);
        DefaultCamelContextSuspendResumeRouteTest.assertTrue((boolean)this.context.isSuspended());
        DefaultCamelContextSuspendResumeRouteTest.assertFalse((boolean)this.context.getStatus().isStarted());
        DefaultCamelContextSuspendResumeRouteTest.assertTrue((boolean)this.context.getStatus().isSuspended());
        DefaultCamelContextSuspendResumeRouteTest.assertFalse((boolean)this.context.getStatus().isStopped());
        this.log.info("Resuming");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.resume();
        this.assertMockEndpointsSatisfied();
        DefaultCamelContextSuspendResumeRouteTest.assertFalse((boolean)this.context.isSuspended());
        DefaultCamelContextSuspendResumeRouteTest.assertTrue((boolean)this.context.getStatus().isStarted());
        DefaultCamelContextSuspendResumeRouteTest.assertFalse((boolean)this.context.getStatus().isSuspended());
        DefaultCamelContextSuspendResumeRouteTest.assertFalse((boolean)this.context.getStatus().isStopped());
        this.context.stop();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

