/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.impl.DefaultExchange;

public class DefaultConsumerTemplateTest
extends ContextTestSupport {
    private DefaultConsumerTemplate consumer;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.consumer = new DefaultConsumerTemplate((CamelContext)this.context);
        this.consumer.start();
    }

    @Override
    protected void tearDown() throws Exception {
        this.consumer.stop();
        super.tearDown();
    }

    public void testConsumeReceive() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        Exchange out = this.consumer.receive("seda:foo");
        DefaultConsumerTemplateTest.assertNotNull((Object)out);
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
        DefaultConsumerTemplateTest.assertSame((Object)this.context, (Object)this.consumer.getCamelContext());
    }

    public void testConsumeTwiceReceive() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        Exchange out = this.consumer.receive("seda:foo");
        DefaultConsumerTemplateTest.assertNotNull((Object)out);
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
        this.template.sendBody("seda:foo", (Object)"Bye");
        out = this.consumer.receive("seda:foo");
        DefaultConsumerTemplateTest.assertNotNull((Object)out);
        DefaultConsumerTemplateTest.assertEquals((Object)"Bye", (Object)out.getIn().getBody());
    }

    public void testConsumeReceiveNoWait() throws Exception {
        Exchange out = this.consumer.receiveNoWait("seda:foo");
        DefaultConsumerTemplateTest.assertNull((Object)out);
        this.template.sendBody("seda:foo", (Object)"Hello");
        Thread.sleep(500L);
        out = this.consumer.receiveNoWait("seda:foo");
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
    }

    public void testConsumeReceiveTimeout() throws Exception {
        long start = System.currentTimeMillis();
        Exchange out = this.consumer.receive("seda:foo", 1000L);
        DefaultConsumerTemplateTest.assertNull((Object)out);
        long delta = System.currentTimeMillis() - start;
        DefaultConsumerTemplateTest.assertTrue((String)("Should take about 1 sec: " + delta), (delta < 1500L ? 1 : 0) != 0);
        this.template.sendBody("seda:foo", (Object)"Hello");
        out = this.consumer.receive("seda:foo");
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
    }

    public void testConsumeReceiveBody() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        Object body = this.consumer.receiveBody("seda:foo");
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)body);
    }

    public void testConsumeTwiceReceiveBody() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        Object body = this.consumer.receiveBody("seda:foo");
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)body);
        this.template.sendBody("seda:foo", (Object)"Bye");
        body = this.consumer.receiveBody("seda:foo");
        DefaultConsumerTemplateTest.assertEquals((Object)"Bye", (Object)body);
    }

    public void testConsumeReceiveBodyNoWait() throws Exception {
        Object body = this.consumer.receiveBodyNoWait("seda:foo");
        DefaultConsumerTemplateTest.assertNull((Object)body);
        this.template.sendBody("seda:foo", (Object)"Hello");
        Thread.sleep(500L);
        body = this.consumer.receiveBodyNoWait("seda:foo");
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)body);
    }

    public void testConsumeReceiveBodyString() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        String body = (String)this.consumer.receiveBody("seda:foo", String.class);
        DefaultConsumerTemplateTest.assertEquals((String)"Hello", (String)body);
    }

    public void testConsumeTwiceReceiveBodyString() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        String body = (String)this.consumer.receiveBody("seda:foo", String.class);
        DefaultConsumerTemplateTest.assertEquals((String)"Hello", (String)body);
        this.template.sendBody("seda:foo", (Object)"Bye");
        body = (String)this.consumer.receiveBody("seda:foo", String.class);
        DefaultConsumerTemplateTest.assertEquals((String)"Bye", (String)body);
    }

    public void testConsumeReceiveBodyStringNoWait() throws Exception {
        String body = (String)this.consumer.receiveBodyNoWait("seda:foo", String.class);
        DefaultConsumerTemplateTest.assertNull((Object)body);
        this.template.sendBody("seda:foo", (Object)"Hello");
        Thread.sleep(400L);
        body = (String)this.consumer.receiveBodyNoWait("seda:foo", String.class);
        DefaultConsumerTemplateTest.assertEquals((String)"Hello", (String)body);
    }

    public void testConsumeReceiveEndpoint() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        DefaultConsumerTemplateTest.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        Exchange out = this.consumer.receive(endpoint);
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
    }

    public void testConsumeReceiveEndpointTimeout() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        DefaultConsumerTemplateTest.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        Exchange out = this.consumer.receive(endpoint, 1000L);
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
    }

    public void testConsumeReceiveEndpointNoWait() throws Exception {
        DefaultConsumerTemplateTest.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        Exchange out = this.consumer.receiveNoWait(endpoint);
        DefaultConsumerTemplateTest.assertNull((Object)out);
        this.template.sendBody("seda:foo", (Object)"Hello");
        Thread.sleep(400L);
        out = this.consumer.receiveNoWait(endpoint);
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)out.getIn().getBody());
    }

    public void testConsumeReceiveEndpointBody() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        DefaultConsumerTemplateTest.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        Object body = this.consumer.receiveBody(endpoint);
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)body);
    }

    public void testConsumeReceiveEndpointBodyTimeout() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        DefaultConsumerTemplateTest.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        Object body = this.consumer.receiveBody(endpoint, 1000L);
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)body);
    }

    public void testConsumeReceiveEndpointBodyType() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        DefaultConsumerTemplateTest.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        String body = (String)this.consumer.receiveBody(endpoint, String.class);
        DefaultConsumerTemplateTest.assertEquals((String)"Hello", (String)body);
    }

    public void testConsumeReceiveEndpointBodyTimeoutType() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        DefaultConsumerTemplateTest.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        String body = (String)this.consumer.receiveBody(endpoint, 1000L, String.class);
        DefaultConsumerTemplateTest.assertEquals((String)"Hello", (String)body);
    }

    public void testConsumeReceiveBodyTimeoutType() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello");
        String body = (String)this.consumer.receiveBody("seda:foo", 1000L, String.class);
        DefaultConsumerTemplateTest.assertEquals((String)"Hello", (String)body);
    }

    public void testConsumeReceiveEndpointBodyTypeNoWait() throws Exception {
        DefaultConsumerTemplateTest.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        String out = (String)this.consumer.receiveBodyNoWait(endpoint, String.class);
        DefaultConsumerTemplateTest.assertNull((Object)out);
        this.template.sendBody("seda:foo", (Object)"Hello");
        Thread.sleep(400L);
        out = (String)this.consumer.receiveBodyNoWait(endpoint, String.class);
        DefaultConsumerTemplateTest.assertEquals((String)"Hello", (String)out);
    }

    public void testConsumeReceiveEndpointBodyNoWait() throws Exception {
        DefaultConsumerTemplateTest.assertNotNull((Object)this.consumer.getCamelContext());
        Endpoint endpoint = this.context.getEndpoint("seda:foo");
        Object out = this.consumer.receiveBodyNoWait(endpoint);
        DefaultConsumerTemplateTest.assertNull((Object)out);
        this.template.sendBody("seda:foo", (Object)"Hello");
        Thread.sleep(400L);
        out = this.consumer.receiveBodyNoWait(endpoint);
        DefaultConsumerTemplateTest.assertEquals((Object)"Hello", (Object)out);
    }

    public void testReceiveException() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setException((Throwable)new IllegalArgumentException("Damn"));
        Exchange out = this.template.send("seda:foo", (Exchange)exchange);
        DefaultConsumerTemplateTest.assertTrue((boolean)out.isFailed());
        DefaultConsumerTemplateTest.assertNotNull((Object)out.getException());
        try {
            this.consumer.receiveBody("seda:foo", String.class);
            DefaultConsumerTemplateTest.fail((String)"Should have thrown an exception");
        }
        catch (RuntimeCamelException e) {
            DefaultConsumerTemplateTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            DefaultConsumerTemplateTest.assertEquals((String)"Damn", (String)e.getCause().getMessage());
        }
    }

    public void testReceiveOut() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getOut().setBody((Object)"Bye World");
        this.template.send("seda:foo", (Exchange)exchange);
        String out = (String)this.consumer.receiveBody("seda:foo", String.class);
        DefaultConsumerTemplateTest.assertEquals((String)"Bye World", (String)out);
    }

    public void testCacheConsumers() throws Exception {
        DefaultConsumerTemplate template = new DefaultConsumerTemplate((CamelContext)this.context);
        template.setMaximumCacheSize(500);
        template.start();
        DefaultConsumerTemplateTest.assertEquals((String)"Size should be 0", (int)0, (int)template.getCurrentCacheSize());
        for (int i = 0; i < 503; ++i) {
            Endpoint e = this.context.getEndpoint("direct:queue:" + i);
            template.receiveNoWait(e);
        }
        DefaultConsumerTemplateTest.assertEquals((String)"Size should be 500", (int)500, (int)template.getCurrentCacheSize());
        template.stop();
        DefaultConsumerTemplateTest.assertEquals((String)"Size should be 0", (int)0, (int)template.getCurrentCacheSize());
    }

    public void testCacheConsumersFromContext() throws Exception {
        ConsumerTemplate template = this.context.createConsumerTemplate(500);
        DefaultConsumerTemplateTest.assertEquals((String)"Size should be 0", (int)0, (int)template.getCurrentCacheSize());
        for (int i = 0; i < 503; ++i) {
            Endpoint e = this.context.getEndpoint("direct:queue:" + i);
            template.receiveNoWait(e);
        }
        DefaultConsumerTemplateTest.assertEquals((String)"Size should be 500", (int)500, (int)template.getCurrentCacheSize());
        template.stop();
        DefaultConsumerTemplateTest.assertEquals((String)"Size should be 0", (int)0, (int)template.getCurrentCacheSize());
    }

    public void testDoneUoW() throws Exception {
        DefaultConsumerTemplateTest.deleteDirectory("target/foo");
        this.template.sendBodyAndHeader("file:target/foo", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        Exchange exchange = this.consumer.receive("file:target/foo?delete=true");
        DefaultConsumerTemplateTest.assertNotNull((Object)exchange);
        DefaultConsumerTemplateTest.assertEquals((String)"Hello World", (String)((String)exchange.getIn().getBody(String.class)));
        File file = new File("target/foo/hello.txt");
        DefaultConsumerTemplateTest.assertTrue((String)("File should exist " + file), (boolean)file.exists());
        this.consumer.doneUoW(exchange);
        DefaultConsumerTemplateTest.assertFalse((String)("File should have been deleted " + file), (boolean)file.exists());
    }
}

