/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.util.URISupport;

public class DefaultEndpointTest
extends ContextTestSupport {
    public void testSanitizeUri() {
        DefaultEndpointTest.assertNull((Object)URISupport.sanitizeUri(null));
        DefaultEndpointTest.assertEquals((String)"", (String)URISupport.sanitizeUri((String)""));
        this.assertSanitizedUriUnchanged("http://camel.apache.org");
        this.assertSanitizedUriUnchanged("irc://irc.codehaus.org/camel");
        this.assertSanitizedUriUnchanged("direct:foo?bar=123&cheese=yes");
        this.assertSanitizedUriUnchanged("https://issues.apache.org/activemq/secure/AddComment!default.jspa?id=33239");
        DefaultEndpointTest.assertEquals((String)"ftp://host.mysite.com/records?passiveMode=true&user=someuser&password=xxxxxx", (String)URISupport.sanitizeUri((String)"ftp://host.mysite.com/records?passiveMode=true&user=someuser&password=superSecret"));
        DefaultEndpointTest.assertEquals((String)"sftp://host.mysite.com/records?user=someuser&privateKeyFile=key.file&privateKeyFilePassphrase=xxxxxx&knownHostsFile=hosts.list", (String)URISupport.sanitizeUri((String)"sftp://host.mysite.com/records?user=someuser&privateKeyFile=key.file&privateKeyFilePassphrase=superSecret&knownHostsFile=hosts.list"));
        DefaultEndpointTest.assertEquals((String)"aws-sqs://MyQueue?accessKey=1672t4rflhnhli3&secretKey=xxxxxx", (String)URISupport.sanitizeUri((String)"aws-sqs://MyQueue?accessKey=1672t4rflhnhli3&secretKey=qi472qfberu33dqjncq"));
    }

    private void assertSanitizedUriUnchanged(String uri) {
        DefaultEndpointTest.assertEquals((String)uri, (String)URISupport.sanitizeUri((String)uri));
    }
}

