/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.impl.EmptyProducerCache;

public class EmptyProducerCacheTest
extends ContextTestSupport {
    public void testEmptyCache() throws Exception {
        EmptyProducerCache cache = new EmptyProducerCache((Object)this, (CamelContext)this.context);
        cache.start();
        EmptyProducerCacheTest.assertEquals((String)"Size should be 0", (int)0, (int)cache.size());
        Endpoint e = this.context.getEndpoint("direct:queue:1");
        Producer p = cache.acquireProducer(e);
        EmptyProducerCacheTest.assertEquals((String)"Size should be 0", (int)0, (int)cache.size());
        cache.releaseProducer(e, p);
        EmptyProducerCacheTest.assertEquals((String)"Size should be 0", (int)0, (int)cache.size());
        cache.stop();
    }

    public void testCacheProducerAcquireAndRelease() throws Exception {
        EmptyProducerCache cache = new EmptyProducerCache((Object)this, (CamelContext)this.context);
        cache.start();
        EmptyProducerCacheTest.assertEquals((String)"Size should be 0", (int)0, (int)cache.size());
        for (int i = 0; i < 1003; ++i) {
            Endpoint e = this.context.getEndpoint("direct:queue:" + i);
            Producer p = cache.acquireProducer(e);
            cache.releaseProducer(e, p);
        }
        EmptyProducerCacheTest.assertEquals((String)"Size should be 1000", (int)0, (int)cache.size());
        cache.stop();
    }
}

