/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.impl.ConfigurationHelper;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.MappedEndpointConfiguration;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class EndpointConfigurationTest {
    private static final String MAPPED_SCHEME = "mapped";
    private static CamelContext context;

    @BeforeClass
    public static void createContext() throws Exception {
        context = new DefaultCamelContext();
        ConfiguredComponent component = new ConfiguredComponent();
        context.addComponent(MAPPED_SCHEME, (Component)component);
        context.start();
    }

    @AfterClass
    public static void destroyContext() throws Exception {
        context.stop();
        context = null;
    }

    @Test
    public void testConfigurationInstanceType() throws Exception {
        EndpointConfiguration cfg = ConfigurationHelper.createConfiguration((String)"mapped:foo", (CamelContext)context);
        Assert.assertEquals((String)"EndpointConfiguration instance not of expected type", MappedEndpointConfiguration.class, cfg.getClass());
    }

    @Test
    public void testConfigurationEquals() throws Exception {
        EndpointConfiguration cfg1 = ConfigurationHelper.createConfiguration((String)"mapped://foo?one=true&two=2", (CamelContext)context);
        EndpointConfiguration cfg2 = ConfigurationHelper.createConfiguration((String)"mapped://foo?two=2&one=true", (CamelContext)context);
        String uri1 = cfg1.toUriString(EndpointConfiguration.UriFormat.Complete);
        String uri2 = cfg2.toUriString(EndpointConfiguration.UriFormat.Complete);
        Assert.assertEquals((String)"Query parameter order should not matter", (Object)uri1, (Object)uri2);
    }

    @Test
    @Ignore(value="Fails due CAMEL-5183")
    public void testConfigurationPortParameter() throws Exception {
        EndpointConfiguration cfg1 = ConfigurationHelper.createConfiguration((String)"mapped://foo:8080?one=true&two=2&port=123", (CamelContext)context);
        String uri1 = cfg1.toUriString(EndpointConfiguration.UriFormat.Complete);
        Assert.assertEquals((Object)"mapped://foo:8080?one=true&port=123&two=2", (Object)uri1);
    }

    private static class ConfiguredComponent
    implements Component {
        private CamelContext context;

        private ConfiguredComponent() {
        }

        public void setCamelContext(CamelContext camelContext) {
            this.context = camelContext;
        }

        public CamelContext getCamelContext() {
            return this.context;
        }

        public Endpoint createEndpoint(String uri) throws Exception {
            return null;
        }

        public ComponentConfiguration createComponentConfiguration() {
            return null;
        }

        public EndpointConfiguration createConfiguration(String uri) throws Exception {
            return new MappedEndpointConfiguration(this.getCamelContext());
        }

        public boolean useRawUri() {
            return false;
        }
    }
}

