/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import junit.framework.TestCase;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;

public class EndpointShutdownOnceTest
extends TestCase {
    public void testEndpointShutdown() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.addComponent("my", (Component)new MyComponent());
        context.start();
        MyEndpoint my = (MyEndpoint)context.getEndpoint("my:foo", MyEndpoint.class);
        EndpointShutdownOnceTest.assertTrue((String)"Should be started", (boolean)my.getStatus().isStarted());
        context.stop();
        EndpointShutdownOnceTest.assertFalse((String)"Should not be started", (boolean)my.getStatus().isStarted());
        EndpointShutdownOnceTest.assertTrue((String)"Should be stopped", (boolean)my.getStatus().isStopped());
        EndpointShutdownOnceTest.assertEquals((String)"Should only shutdown once", (int)1, (int)my.getInvoked());
    }

    private static final class MyEndpoint
    extends DefaultEndpoint {
        private volatile int invoked;

        private MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public int getInvoked() {
            return this.invoked;
        }

        public Producer createProducer() throws Exception {
            return null;
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }

        protected void doShutdown() throws Exception {
            super.doShutdown();
            ++this.invoked;
        }
    }

    private static final class MyComponent
    extends DefaultComponent {
        private MyComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            return new MyEndpoint(uri, (Component)this);
        }
    }
}

