/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;

public class GzipDataFormatFileUnmarshalDeleteTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        GzipDataFormatFileUnmarshalDeleteTest.deleteDirectory("target/gzip");
        super.setUp();
    }

    public void testGzipFileUnmarshalDelete() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(2).create();
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file:target/gzip", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        notify.matchesMockWaitTime();
        File in = new File("target/gzip/hello.txt");
        GzipDataFormatFileUnmarshalDeleteTest.assertFalse((String)("Should have been deleted " + in), (boolean)in.exists());
        File out = new File("target/gzip/out/hello.txt.gz");
        GzipDataFormatFileUnmarshalDeleteTest.assertFalse((String)("Should have been deleted " + out), (boolean)out.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/gzip?delete=true").marshal().gzip().to("file:target/gzip/out?fileName=${file:name}.gz");
                this.from("file:target/gzip/out?delete=true").unmarshal().gzip().to("mock:result");
            }
        };
    }
}

