/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class LogDebugBodyMaxCharsTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.context.getProperties().put("CamelLogDebugBodyMaxChars", "20");
    }

    public void testLogBodyMaxLengthTest() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            int value = i % 10;
            sb.append(value);
        }
        String body = sb.toString();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        String msg = ((Exchange)mock.getReceivedExchanges().get(0)).getIn().toString();
        LogDebugBodyMaxCharsTest.assertEquals((String)"Message: 01234567890123456789... [Body clipped after 20 chars, total length is 1000]", (String)msg);
        LogDebugBodyMaxCharsTest.assertNotSame((String)"clipped log and real body should not be the same", (Object)msg, (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(String.class));
    }

    public void testNotClipped() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"1234567890");
        this.assertMockEndpointsSatisfied();
        String msg = ((Exchange)mock.getReceivedExchanges().get(0)).getIn().toString();
        LogDebugBodyMaxCharsTest.assertEquals((String)"Message: 1234567890", (String)msg);
        LogDebugBodyMaxCharsTest.assertNotSame((String)"clipped log and real body should not be the same", (Object)msg, (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(String.class));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

