/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.camel.spi.RoutePolicy;
import org.junit.Test;

public class RoutePolicySupportTest
extends ContextTestSupport {
    private MyRoutePolicy policy = new MyRoutePolicy();

    @Test
    public void testLifecycleCallbacks() throws Exception {
        Route route = this.context.getRoute("foo");
        RoutePolicySupportTest.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteStatus("foo"));
        this.policy.startRoute(route);
        RoutePolicySupportTest.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteStatus("foo"));
        this.policy.suspendRoute(route);
        RoutePolicySupportTest.assertEquals((Object)ServiceStatus.Suspended, (Object)this.context.getRouteStatus("foo"));
        this.policy.resumeRoute(route);
        RoutePolicySupportTest.assertEquals((Object)ServiceStatus.Started, (Object)this.context.getRouteStatus("foo"));
        this.policy.stopRoute(route);
        RoutePolicySupportTest.assertEquals((Object)ServiceStatus.Stopped, (Object)this.context.getRouteStatus("foo"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").routePolicy(new RoutePolicy[]{RoutePolicySupportTest.this.policy}).autoStartup(false).to("mock:result");
            }
        };
    }

    public static class MyRoutePolicy
    extends RoutePolicySupport {
    }
}

