/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.Mock321ScheduledPollConsumer;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public class ScheduledPollConsumerGreedyTest
extends ContextTestSupport {
    private final AtomicInteger polled = new AtomicInteger();

    public void test321Greedy() throws Exception {
        this.polled.set(0);
        Mock321ScheduledPollConsumer consumer = new Mock321ScheduledPollConsumer((DefaultEndpoint)this.getMockEndpoint("mock:foo"), null);
        consumer.setGreedy(true);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
                ScheduledPollConsumerGreedyTest.this.polled.addAndGet(polledMessages);
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) throws Exception {
                return false;
            }
        });
        consumer.start();
        consumer.run();
        ScheduledPollConsumerGreedyTest.assertEquals((int)6, (int)this.polled.get());
        consumer.stop();
    }

    public void test321NotGreedy() throws Exception {
        this.polled.set(0);
        Mock321ScheduledPollConsumer consumer = new Mock321ScheduledPollConsumer((DefaultEndpoint)this.getMockEndpoint("mock:foo"), null);
        consumer.setGreedy(false);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
                ScheduledPollConsumerGreedyTest.this.polled.addAndGet(polledMessages);
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) throws Exception {
                return false;
            }
        });
        consumer.start();
        consumer.run();
        ScheduledPollConsumerGreedyTest.assertEquals((int)3, (int)this.polled.get());
        consumer.run();
        ScheduledPollConsumerGreedyTest.assertEquals((int)5, (int)this.polled.get());
        consumer.run();
        ScheduledPollConsumerGreedyTest.assertEquals((int)6, (int)this.polled.get());
        consumer.run();
        ScheduledPollConsumerGreedyTest.assertEquals((int)6, (int)this.polled.get());
        consumer.stop();
    }
}

