/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class SimpleShutdownGracefulNoAtuoStartedTest
extends ContextTestSupport {
    private static String foo = "";

    public void testShutdownGraceful() throws Exception {
        this.context.startRoute("foo");
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        foo = foo + "stop";
        this.context.stop();
        SimpleShutdownGracefulNoAtuoStartedTest.assertEquals((String)"Should graceful shutdown", (String)"stopHello World", (String)foo);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").noAutoStartup().to("mock:foo")).delay(3000L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        foo = foo + (String)exchange.getIn().getBody(String.class);
                    }
                });
            }
        };
    }
}

