/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.StartupListener;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectComponent;

public class StartupListenerComponentTest
extends ContextTestSupport {
    private MyComponent my;

    public void testStartupListenerComponent() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        StartupListenerComponentTest.assertEquals((int)1, (int)this.my.getInvoked());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                StartupListenerComponentTest.this.my = new MyComponent();
                StartupListenerComponentTest.this.context.addComponent("my", (Component)StartupListenerComponentTest.this.my);
                this.from("direct:foo").routeId("foo").to("my:bar");
                this.from("my:bar").routeId("bar").to("mock:result");
            }
        };
    }

    private static class MyComponent
    extends DirectComponent
    implements StartupListener {
        private int invoked;

        private MyComponent() {
        }

        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
            ++this.invoked;
            TestCase.assertTrue((boolean)context.getRouteStatus("foo").isStarted());
            TestCase.assertTrue((boolean)context.getRouteStatus("bar").isStarted());
        }

        public int getInvoked() {
            return this.invoked;
        }
    }
}

