/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.StartupListener;
import org.apache.camel.builder.RouteBuilder;

public class StartupListenerTest
extends ContextTestSupport {
    private MyStartupListener my = new MyStartupListener();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addStartupListener((StartupListener)this.my);
        return context;
    }

    public void testStartupListenerComponent() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        StartupListenerTest.assertEquals((int)1, (int)this.my.getInvoked());
        StartupListenerTest.assertFalse((boolean)this.my.isAlreadyStarted());
    }

    public void testStartupListenerComponentAlreadyStarted() throws Exception {
        MyStartupListener other = new MyStartupListener();
        this.context.addStartupListener((StartupListener)other);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        StartupListenerTest.assertEquals((int)1, (int)other.getInvoked());
        StartupListenerTest.assertTrue((boolean)other.isAlreadyStarted());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").routeId("foo").to("mock:result");
            }
        };
    }

    private static class MyStartupListener
    implements StartupListener {
        private int invoked;
        private boolean alreadyStarted;

        private MyStartupListener() {
        }

        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
            ++this.invoked;
            this.alreadyStarted = alreadyStarted;
            TestCase.assertTrue((boolean)context.getRouteStatus("foo").isStarted());
        }

        public int getInvoked() {
            return this.invoked;
        }

        public boolean isAlreadyStarted() {
            return this.alreadyStarted;
        }
    }
}

