/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class TwoRouteSuspendResumeTest
extends ContextTestSupport {
    public void testSuspendResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Suspending");
        this.resetMocks();
        mock.expectedMessageCount(0);
        MockEndpoint mockBar = this.getMockEndpoint("mock:bar");
        mockBar.expectedMessageCount(1);
        this.context.suspendRoute("foo");
        this.template.sendBody("seda:foo", (Object)"B");
        this.template.sendBody("direct:bar", (Object)"C");
        mockBar.assertIsSatisfied();
        mock.assertIsSatisfied(1000L);
        TwoRouteSuspendResumeTest.assertEquals((String)"Suspended", (String)this.context.getRouteStatus("foo").name());
        TwoRouteSuspendResumeTest.assertEquals((String)"Started", (String)this.context.getRouteStatus("bar").name());
        this.log.info("Resuming");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.resumeRoute("foo");
        this.assertMockEndpointsSatisfied();
        TwoRouteSuspendResumeTest.assertEquals((String)"Started", (String)this.context.getRouteStatus("foo").name());
        TwoRouteSuspendResumeTest.assertEquals((String)"Started", (String)this.context.getRouteStatus("bar").name());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("log:foo")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("log:bar")).to("mock:bar");
            }
        };
    }
}

