/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithUrlIssueTest
extends ContextTestSupport {
    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:test?concurrentConsumers=1").routeId("sedaroute").to("log:before")).to("mock:target");
            }
        };
    }

    public void testProducerWithDifferentUri() throws Exception {
        this.context.getRouteDefinition("sedaroute").adviceWith(this.context, (RouteBuilder)new Advice());
        this.getMockEndpoint("mock:target").expectedMessageCount(0);
        this.getMockEndpoint("mock:target2").expectedMessageCount(1);
        this.template.requestBody("seda:test", (Object)"TESTING");
        this.assertMockEndpointsSatisfied();
    }

    public void testProducerWithSameUri() throws Exception {
        this.context.getRouteDefinition("sedaroute").adviceWith(this.context, (RouteBuilder)new Advice());
        this.getMockEndpoint("mock:target").expectedMessageCount(0);
        this.getMockEndpoint("mock:target2").expectedMessageCount(1);
        this.template.requestBody("seda:test?concurrentConsumers=1", (Object)"TESTING");
        this.assertMockEndpointsSatisfied();
    }

    private class Advice
    extends AdviceWithRouteBuilder {
        private Advice() {
        }

        public void configure() throws Exception {
            this.interceptSendToEndpoint("mock:target").skipSendToOriginalEndpoint().to("mock:target2");
        }
    }
}

