/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class CacheInputStreamInDeadLetterIssue520Test
extends ContextTestSupport {
    private int count;

    public void testSendingInputStream() throws Exception {
        ByteArrayInputStream message = new ByteArrayInputStream("<hello>Willem</hello>".getBytes());
        this.sendingMessage(message);
    }

    public void testSendingReader() throws Exception {
        StringReader message = new StringReader("<hello>Willem</hello>");
        this.sendingMessage(message);
    }

    public void testSendingSource() throws Exception {
        StreamSource message = new StreamSource(new StringReader("<hello>Willem</hello>"));
        this.sendingMessage(message);
    }

    private void sendingMessage(Object message) throws InterruptedException {
        this.count = 0;
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", message);
        CacheInputStreamInDeadLetterIssue520Test.assertEquals((String)"The message should be delivered 4 times", (int)this.count, (int)4);
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                CacheInputStreamInDeadLetterIssue520Test.this.context.setStreamCaching(Boolean.valueOf(true));
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("direct:errorHandler").maximumRedeliveries(3).redeliveryDelay(0L));
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        CacheInputStreamInDeadLetterIssue520Test.this.count++;
                        String result = (String)exchange.getIn().getBody(String.class);
                        TestCase.assertEquals((String)"Should read the inputstream out again", (String)"<hello>Willem</hello>", (String)result);
                        throw new Exception("Forced exception by unit test");
                    }
                });
                ((RouteDefinition)this.from("direct:errorHandler").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String result = (String)exchange.getIn().getBody(String.class);
                        TestCase.assertEquals((String)"Should read the inputstream out again", (String)"<hello>Willem</hello>", (String)result);
                    }
                })).to("mock:error");
            }
        };
    }
}

