/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;

public class ConsumerTemplateSedaQueueIssueTest
extends ContextTestSupport {
    public void testConsumerTemplateSedaQueue() throws Exception {
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"C");
        this.template.sendBody("direct:start", (Object)"D");
        this.template.sendBody("direct:start", (Object)"E");
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda:foo", SedaEndpoint.class);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((int)5, (int)seda.getCurrentQueueSize());
        String body = (String)this.consumer.receiveBody((Endpoint)seda, 1000L, String.class);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((String)"A", (String)body);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((int)4, (int)seda.getCurrentQueueSize());
        body = (String)this.consumer.receiveBody((Endpoint)seda, 1000L, String.class);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((String)"B", (String)body);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((int)3, (int)seda.getCurrentQueueSize());
        body = (String)this.consumer.receiveBody((Endpoint)seda, 1000L, String.class);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((String)"C", (String)body);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((int)2, (int)seda.getCurrentQueueSize());
        body = (String)this.consumer.receiveBody((Endpoint)seda, 1000L, String.class);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((String)"D", (String)body);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((int)1, (int)seda.getCurrentQueueSize());
        body = (String)this.consumer.receiveBody((Endpoint)seda, 1000L, String.class);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((String)"E", (String)body);
        ConsumerTemplateSedaQueueIssueTest.assertEquals((int)0, (int)seda.getCurrentQueueSize());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("seda:foo");
            }
        };
    }
}

